/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jei.categories;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.client.render.dye_liquifier.DyeLiquifierContainerScreen;
import wootrevived.woot.compat.jei.WootJeiPluginTypes;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.events.client.GlobalClientTicker;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.render.WootContainerScreen;

public class DyeLiquifierRecipeCategory
implements IRecipeCategory<DyeLiquifierRecipe> {
    private static IDrawable icon;
    private static final int GUI_WIDTH = 119;
    private static final int GUI_HEIGHT = 56;
    private static final int ENERGY_X = 0;
    private static final int ENERGY_Y = 0;
    private static final int INPUT_SLOT_X = 21;
    private static final int INPUT_SLOT_Y = 19;
    private static final int COLOR_BAR_X = 63;
    private static final int RED_COLOR_BAR_Y = 5;
    private static final int YELLOW_COLOR_BAR_Y = 17;
    private static final int BLUE_COLOR_BAR_Y = 29;
    private static final int WHITE_COLOR_BAR_Y = 41;
    private static final int PROGRESS_X = 42;
    private static final int PROGRESS_Y = 7;

    public DyeLiquifierRecipeCategory(IGuiHelper guiHelper) {
        icon = guiHelper.createDrawableItemStack(((Item)BlocksRegistry.DYE_LIQUIFIER_BLOCK_ITEM.get()).getDefaultInstance());
    }

    public void draw(DyeLiquifierRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        int totalProgressTick = recipe.getEnergy() / (Integer)DyeLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
        int progress = GlobalClientTicker.tickCounter % totalProgressTick * 100 / totalProgressTick;
        WootContainerScreen.renderVanillaSlot(gui, 21, 19);
        WootContainerScreen.renderColorBarBg(gui, 63, 5, DyeColor.RED.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        WootContainerScreen.renderColorBarBg(gui, 63, 17, DyeColor.YELLOW.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        WootContainerScreen.renderColorBarBg(gui, 63, 29, DyeColor.BLUE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        WootContainerScreen.renderColorBarBg(gui, 63, 41, DyeColor.WHITE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        WootContainerScreen.renderEnergyBg(gui, 0, 0);
        DyeLiquifierContainerScreen.renderProgressBg(gui, 42, 7);
        WootContainerScreen.renderEnergy(gui, 0, 0, recipe.getEnergy(), (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get());
        WootContainerScreen.renderColorBar(gui, 63, 5, recipe.getRed(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.RED.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        WootContainerScreen.renderColorBar(gui, 63, 17, recipe.getYellow(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.YELLOW.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        WootContainerScreen.renderColorBar(gui, 63, 29, recipe.getBlue(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.BLUE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        WootContainerScreen.renderColorBar(gui, 63, 41, recipe.getWhite(), Math.round((float)((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue() * DyeLiquifierRecipe.maxMultiplier), DyeColor.WHITE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderProgress(gui, 42, 7, progress);
        WootContainerScreen._renderEnergyTooltip(gui, (int)mouseX, (int)mouseY, 0, 0, recipe.getEnergy(), (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get(), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 5, recipe.getRed(), 0, Component.translatable((String)"info.woot_revived.dye.red"), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 17, recipe.getYellow(), 0, Component.translatable((String)"info.woot_revived.dye.yellow"), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 29, recipe.getBlue(), 0, Component.translatable((String)"info.woot_revived.dye.blue"), false, false);
        WootContainerScreen._renderColorBarTooltip(gui, (int)mouseX, (int)mouseY, 63, 41, recipe.getWhite(), 0, Component.translatable((String)"info.woot_revived.dye.white"), false, false);
        DyeLiquifierContainerScreen._renderProgressTooltip(gui, (int)mouseX, (int)mouseY, 42, 7, progress, Math.max(0.0f, (float)totalProgressTick / 20.0f), (Integer)DyeLiquifierConfig.ENERGY_PROCESS_TRANSFER.get(), false);
    }

    public int getWidth() {
        return 119;
    }

    public int getHeight() {
        return 56;
    }

    @NotNull
    public RecipeType<DyeLiquifierRecipe> getRecipeType() {
        return WootJeiPluginTypes.DYE_LIQUIFIER_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.woot_revived.dye_liquifier.name");
    }

    @NotNull
    public IDrawable getIcon() {
        return icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DyeLiquifierRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 22, 20).addIngredients(recipe.getIngredient());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addFluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get(), 1L).addItemStack(((BucketItem)FluidsRegistry.PURE_DYE_FLUID_BUCKET.get()).getDefaultInstance());
    }
}

