/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.compat.jade;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import wootrevived.woot.Woot;
import wootrevived.woot.util.entity.WootMachineBlockEntity;

public enum WootMachineProvider implements IBlockComponentProvider,
StreamServerDataProvider<BlockAccessor, Data>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Data data = this.decodeFromData((Accessor)accessor).orElse(null);
        if (data != null) {
            IElementHelper helper = IElementHelper.get();
            BoxStyle.GradientBorder box = BoxStyle.getTransparent().clone();
            box.bgColor = -2013265920;
            tooltip.add(helper.progress((float)data.progress / 100.0f, null, helper.progressStyle(), (BoxStyle)box, false));
        }
    }

    public Data streamData(BlockAccessor accessor) {
        WootMachineBlockEntity entity = (WootMachineBlockEntity)accessor.getBlockEntity();
        return new Data(entity.calculateProgress());
    }

    public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
        return Data.STREAM_CODEC;
    }

    public ResourceLocation getUid() {
        return Woot.location("machines");
    }

    public record Data(int progress) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::progress, Data::new);
    }
}

