/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.sprite;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.Woot;
import wootrevived.woot.registries.UpgradeItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public record UpgradeItemDynamicSpriteSource(ResourceLocation id) implements SpriteSource
{
    public static final MapCodec<UpgradeItemDynamicSpriteSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(UpgradeItemDynamicSpriteSource::id)).apply((Applicative)instance, UpgradeItemDynamicSpriteSource::new));
    public static final SpriteSourceType TYPE = new SpriteSourceType(CODEC);

    public void run(@NotNull ResourceManager resourceManager, @NotNull SpriteSource.Output output) {
        Collection<UpgradeItemsRegistry.DynamicEntry<?>> dynamicItems = UpgradeItemsRegistry.getDynamicEntries();
        for (UpgradeItemsRegistry.DynamicEntry<?> entry : dynamicItems) {
            this.processDynamicEntry(entry, resourceManager, output);
        }
    }

    private <T extends Enum<T>> void processDynamicEntry(UpgradeItemsRegistry.DynamicEntry<T> entry, ResourceManager resourceManager, SpriteSource.Output output) {
        WootUpgradeItem item = (WootUpgradeItem)((Object)entry.item().get());
        for (Enum variant : (Enum[])entry.variantClass().getEnumConstants()) {
            ResourceLocation upgradeItemResourceLocation = item.getTextureLocation(variant);
            Resource upgradeItemResource = this.getResource(resourceManager, upgradeItemResourceLocation);
            LazyLoadedImage upgradeItemImage = new LazyLoadedImage(upgradeItemResourceLocation, upgradeItemResource, 1);
            ResourceLocation spriteLocation = Woot.location("item/upgrade_item_" + ((StringRepresentable)variant).getSerializedName() + "_" + UpgradeItemsRegistry.getNameFromItem(entry.item()));
            output.add(spriteLocation, new UpgradeSpriteSupplier<Enum>((WootUpgradeItem)((Object)entry.item().get()), variant, upgradeItemImage, spriteLocation));
        }
    }

    private Resource getResource(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        Optional optionalResource = resourceManager.getResource(resourceLocation);
        if (optionalResource.isPresent()) {
            return (Resource)optionalResource.get();
        }
        throw new RuntimeException("Could not find resource: " + String.valueOf(resourceLocation));
    }

    @NotNull
    public SpriteSourceType type() {
        return TYPE;
    }

    public record UpgradeSpriteSupplier<T extends Enum<T>>(WootUpgradeItem<T> upgradeItem, T variant, LazyLoadedImage lazyUpgradeImage, ResourceLocation location) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader spriteResourceLoader) {
            try {
                NativeImage upgradeImage = this.lazyUpgradeImage.get();
                NativeImage image = new NativeImage(upgradeImage.getWidth(), upgradeImage.getHeight(), false);
                image.copyFrom(upgradeImage);
                this.upgradeItem.applyItemTexture(image, this.variant);
                SpriteContents spriteContents = new SpriteContents(this.location, new FrameSize(image.getWidth(), image.getHeight()), image, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException iOException) {
            }
            finally {
                this.discard();
            }
            return null;
        }

        public void discard() {
            this.lazyUpgradeImage.release();
        }
    }
}

