/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.sprite;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.Woot;
import wootrevived.woot.registries.UpgradeItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public record FactoryUpgradeDynamicSpriteSource(ResourceLocation id) implements SpriteSource
{
    private static final MapCodec<FactoryUpgradeDynamicSpriteSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FactoryUpgradeDynamicSpriteSource::id)).apply((Applicative)instance, FactoryUpgradeDynamicSpriteSource::new));
    public static final SpriteSourceType TYPE = new SpriteSourceType(CODEC);

    public void run(@NotNull ResourceManager resourceManager, @NotNull SpriteSource.Output output) {
        Collection<UpgradeItemsRegistry.DynamicEntry<?>> dynamicItems = UpgradeItemsRegistry.getDynamicEntries();
        for (UpgradeItemsRegistry.DynamicEntry<?> entry : dynamicItems) {
            this.processDynamicEntry(entry, resourceManager, output);
        }
        Collection<UpgradeItemsRegistry.Entry<?>> items = UpgradeItemsRegistry.getEntries();
        ResourceLocation factoryUpgradeResourceLocation = Woot.location("textures/block/factory_upgrade.png");
        Resource factoryResource = this.getResource(resourceManager, factoryUpgradeResourceLocation);
        LazyLoadedImage factoryImage = new LazyLoadedImage(factoryUpgradeResourceLocation, factoryResource, items.size());
        for (UpgradeItemsRegistry.Entry<?> entry : items) {
            this.processEntry(entry, factoryImage, resourceManager, output);
        }
    }

    private <T extends Enum<T>> void processEntry(UpgradeItemsRegistry.Entry<T> entry, LazyLoadedImage factoryImage, ResourceManager resourceManager, SpriteSource.Output output) {
        WootUpgradeItem item = (WootUpgradeItem)((Object)entry.item().get());
        Object variant = item.getVariant(null);
        ResourceLocation upgradeItemResourceLocation = item.getTextureLocation(variant);
        Resource upgradeItemResource = this.getResource(resourceManager, upgradeItemResourceLocation);
        LazyLoadedImage upgradeItemImage = new LazyLoadedImage(upgradeItemResourceLocation, upgradeItemResource, 1);
        ResourceLocation spriteLocation = Woot.location("block/upgrade_item_" + UpgradeItemsRegistry.getNameFromItem(entry.item()));
        output.add(spriteLocation, new UpgradeSpriteSupplier(item, variant, factoryImage, upgradeItemImage, spriteLocation));
    }

    private <T extends Enum<T>> void processDynamicEntry(UpgradeItemsRegistry.DynamicEntry<T> entry, ResourceManager resourceManager, SpriteSource.Output output) {
        Enum[] variants = (Enum[])entry.variantClass().getEnumConstants();
        ResourceLocation factoryUpgradeResourceLocation = Woot.location("textures/block/factory_upgrade.png");
        Resource factoryResource = this.getResource(resourceManager, factoryUpgradeResourceLocation);
        LazyLoadedImage factoryImage = new LazyLoadedImage(factoryUpgradeResourceLocation, factoryResource, variants.length);
        WootUpgradeItem item = (WootUpgradeItem)((Object)entry.item().get());
        for (Enum variant : variants) {
            ResourceLocation upgradeItemResourceLocation = item.getTextureLocation(variant);
            Resource upgradeItemResource = this.getResource(resourceManager, upgradeItemResourceLocation);
            LazyLoadedImage upgradeItemImage = new LazyLoadedImage(upgradeItemResourceLocation, upgradeItemResource, 1);
            ResourceLocation spriteLocation = Woot.location("block/upgrade_item_" + ((StringRepresentable)variant).getSerializedName() + "_" + UpgradeItemsRegistry.getNameFromItem(entry.item()));
            output.add(spriteLocation, new UpgradeSpriteSupplier<Enum>((WootUpgradeItem)((Object)entry.item().get()), variant, factoryImage, upgradeItemImage, spriteLocation));
        }
    }

    private Resource getResource(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        Optional optionalResource = resourceManager.getResource(resourceLocation);
        if (optionalResource.isPresent()) {
            return (Resource)optionalResource.get();
        }
        throw new RuntimeException("Could not find resource: " + String.valueOf(resourceLocation));
    }

    @NotNull
    public SpriteSourceType type() {
        return TYPE;
    }

    public record UpgradeSpriteSupplier<T extends Enum<T>>(WootUpgradeItem<T> upgradeItem, T variant, LazyLoadedImage lazyFactoryImage, LazyLoadedImage lazyUpgradeImage, ResourceLocation location) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader spriteResourceLoader) {
            try {
                NativeImage factoryUpgradeImage = this.lazyFactoryImage.get();
                NativeImage imageSide = new NativeImage(factoryUpgradeImage.getWidth(), factoryUpgradeImage.getHeight(), false);
                imageSide.copyFrom(factoryUpgradeImage);
                NativeImage upgradeItemImage = this.lazyUpgradeImage.get();
                this.upgradeItem.applyItemTexture(upgradeItemImage, this.variant);
                this.upgradeItem.applyUpgradeTexture(imageSide, upgradeItemImage, this.variant);
                SpriteContents spriteContents = new SpriteContents(this.location, new FrameSize(imageSide.getWidth(), imageSide.getHeight()), imageSide, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException iOException) {
            }
            finally {
                this.discard();
            }
            return null;
        }

        public void discard() {
            this.lazyFactoryImage.release();
            this.lazyUpgradeImage.release();
        }
    }
}

