/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.heart;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.woot.Woot;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.client.render.heart.HeartContainerMenu;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.common.WootTier;
import wootrevived.woot.util.helper.ModNameHelper;
import wootrevived.woot.util.render.WootButton;
import wootrevived.woot.util.render.WootContainerScreen;
import wootrevived.woot.util.render.WootEntityRenderer;
import wootrevived.woot.util.render.WootSlot;
import wootrevived.woot.util.render.WootSlotItemHandler;
import wootrevived.woot.util.render.WootStyles;
import wootrevived.woot.util.render.buttons.WootHeartInputButton;
import wootrevived.woot.util.render.buttons.WootRedstoneButton;

@OnlyIn(value=Dist.CLIENT)
public class HeartContainerScreen
extends AbstractContainerScreen<HeartContainerMenu> {
    public static final ResourceLocation GUI = Woot.location("textures/gui/atlas.png");
    public static final int GUI_XSIZE = 176;
    public static final int GUI_YSIZE = 184;
    public static final int CELL_TANK_X = 148;
    public static final int CELL_TANK_Y = 57;
    public static final int PRIMARY_MOB_X = 8;
    public static final int PRIMARY_MOB_Y = 17;
    public static final int SECONDARY_MOB_0_X = 130;
    public static final int SECONDARY_MOB_0_Y = 17;
    public static final int SECONDARY_MOB_1_X = 90;
    public static final int SECONDARY_MOB_1_Y = 17;
    public static final int SECONDARY_MOB_2_X = 50;
    public static final int SECONDARY_MOB_2_Y = 17;
    private static final double BOX_SIZE = 32.0;
    private static final double BOX_PADDING = 3.0;
    private static final float MAX_ENTITY_BOX_SIZE = 20.0f;
    public static final int UPGRADE_SLOT_0_X = 10;
    public static final int UPGRADE_SLOT_0_Y = 77;
    public static final int UPGRADE_SLOT_1_X = 28;
    public static final int UPGRADE_SLOT_1_Y = 77;
    public static final int UPGRADE_SLOT_2_X = 46;
    public static final int UPGRADE_SLOT_2_Y = 77;
    public static final int UPGRADE_SLOT_3_X = 64;
    public static final int UPGRADE_SLOT_3_Y = 77;
    public static final int UPGRADE_SLOT_TEXT_X = 10;
    public static final int UPGRADE_SLOT_TEXT_Y = 67;
    private final List<WootHeartInputButton> buttons = new ArrayList<WootHeartInputButton>();
    private int activeButton = -1;
    private WootRedstoneButton redstoneButton;

    public HeartContainerScreen(HeartContainerMenu container, Inventory playerInventory, Component name) {
        super((AbstractContainerMenu)container, playerInventory, name);
        this.imageWidth = 176;
        this.imageHeight = 184;
    }

    protected void renderMenuBackground(GuiGraphics gui) {
        this.renderEntityBoxBg(gui, 8, 17);
        this.renderEntityBoxBg(gui, 130, 17);
        this.renderEntityBoxBg(gui, 90, 17);
        this.renderEntityBoxBg(gui, 50, 17);
        this.renderFluidBg(gui, 148, 57);
        WootContainerScreen.renderVanillaSlot(gui, 10, 77);
        WootContainerScreen.renderVanillaSlot(gui, 28, 77);
        WootContainerScreen.renderVanillaSlot(gui, 46, 77);
        WootContainerScreen.renderVanillaSlot(gui, 64, 77);
        gui.drawString(this.font, "Upgrades:", 10, 67, 0x404040, false);
    }

    protected void renderState(GuiGraphics gui) {
        this.renderEntityBox(gui, 8, 17, this.getLivingEntity(0));
        this.renderEntityBox(gui, 130, 17, this.getLivingEntity(1));
        this.renderEntityBox(gui, 90, 17, this.getLivingEntity(2));
        this.renderEntityBox(gui, 50, 17, this.getLivingEntity(3));
        this.renderFluid(gui, 148, 57, ((HeartContainerMenu)this.menu).getCellFluid(), ((HeartContainerMenu)this.menu).getCellFluidCapacity());
        ((HeartContainerMenu)this.menu).updateUpgrades();
        this.updateButton(0);
        this.updateButton(1);
        this.updateButton(2);
        this.updateButton(3);
    }

    protected void renderTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        this.renderEntityTooltip(gui, mouseX, mouseY, 8, 17, 0);
        this.renderEntityTooltip(gui, mouseX, mouseY, 130, 17, 1);
        this.renderEntityTooltip(gui, mouseX, mouseY, 90, 17, 2);
        this.renderEntityTooltip(gui, mouseX, mouseY, 50, 17, 3);
        if (this.activeButton == -1) {
            this.renderFluidTooltip(gui, mouseX, mouseY, 148, 57, ((HeartContainerMenu)this.menu).getCellFluid(), ((HeartContainerMenu)this.menu).getCellFluidCapacity());
        } else {
            List<FluidStack> stacks = ((HeartContainerMenu)this.menu).getFactoryMob(this.activeButton).getImportFluids(((HeartContainerMenu)this.menu).getFactoryMobTag(this.activeButton), (HolderLookup.Provider)((HeartContainerMenu)this.menu).getLevel().registryAccess());
            for (int i = 0; i < 8; ++i) {
                this.renderSmallFluidTooltip(gui, mouseX, mouseY, 9 + i * 20, 73, i >= stacks.size() ? FluidStack.EMPTY : stacks.get(i));
            }
        }
    }

    public void addRenderableWidget(WootHeartInputButton button) {
        this.buttons.add(button);
        this.addWidget((GuiEventListener)button);
    }

    protected void renderFakeSpawner(GuiGraphics gui) {
        gui.fill(4, 56, 172, 159, -3750202);
        gui.blit(GUI, 7, 105, 7, 101, 162, 54);
        for (int i = 0; i < 8; ++i) {
            gui.blit(GUI, 9 + i * 20, 73, 58, 185, 18, 19);
        }
        gui.drawString(this.font, "Needed Fluid Imports", 9, 63, 0x404040, false);
        gui.drawString(this.font, "Needed Item Imports", 7, 95, 0x404040, false);
        WootFactoryMob<?> mob = ((HeartContainerMenu)this.menu).getFactoryMob(this.activeButton);
        CompoundTag tag = ((HeartContainerMenu)this.menu).getFactoryMobTag(this.activeButton);
        ((HeartContainerMenu)this.menu).updateImports(mob.getImportItems(tag, (HolderLookup.Provider)((HeartContainerMenu)this.menu).getLevel().registryAccess()));
        List<FluidStack> stacks = mob.getImportFluids(tag, (HolderLookup.Provider)((HeartContainerMenu)this.menu).getLevel().registryAccess());
        for (int i = 0; i < 8; ++i) {
            this.renderSmallFluid(gui, 9 + i * 20, 73, i >= stacks.size() ? FluidStack.EMPTY : stacks.get(i));
        }
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        this.redstoneButton = new WootRedstoneButton(this.leftPos + 152, this.topPos + 57, RedstoneMode.ALWAYS_ON, button -> {
            RedstoneMode mode = button.nextMode();
            FakeSpawnerBlockEntity entity = ((HeartContainerMenu)this.menu).getFakeSpawner(this.buttons.get(this.activeButton).getFakeSpawnerIndex());
            entity.setRedstoneMode(mode);
            entity.sendNewState();
        });
        this.addRenderableWidget((GuiEventListener)this.redstoneButton);
        this.redstoneButton.active = false;
        this.createButton(8, 17, 0);
        this.createButton(130, 17, 1);
        this.createButton(90, 17, 2);
        this.createButton(50, 17, 3);
        if (this.activeButton != -1) {
            this.buttons.get((int)this.activeButton).isViewActive = true;
        }
    }

    protected void createButton(int x, int y, int fakeSpawnerIndex) {
        this.addRenderableWidget(new WootHeartInputButton(fakeSpawnerIndex, this.leftPos + x, this.topPos + y, this::setButtonActive));
    }

    public void setButtonActive(WootHeartInputButton button) {
        if (this.activeButton == button.index) {
            this.activeButton = -1;
            button.isViewActive = false;
            this.redstoneButton.active = false;
        } else {
            if (this.activeButton != -1) {
                this.buttons.get((int)this.activeButton).isViewActive = false;
            }
            this.activeButton = button.index;
            button.isViewActive = true;
            this.redstoneButton.active = true;
            this.redstoneButton.setMode(((HeartContainerMenu)this.menu).getFakeSpawner(this.buttons.get(this.activeButton).getFakeSpawnerIndex()).getRedstoneMode());
        }
    }

    protected void updateButton(int fakeSpawnerIndex) {
        WootFactoryMob<?> mob = ((HeartContainerMenu)this.menu).getFactoryMob(fakeSpawnerIndex);
        this.buttons.get((int)fakeSpawnerIndex).active = mob != null && this.isTierEntityValid(mob);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((HeartContainerMenu)this.menu).slots) {
            if (slot instanceof WootSlot) {
                WootSlot wootSlot = (WootSlot)slot;
                wootSlot.setActive(this.activeButton == -1);
                continue;
            }
            if (!(slot instanceof WootSlotItemHandler)) continue;
            WootSlotItemHandler wootSlotItemHandler = (WootSlotItemHandler)slot;
            if (wootSlotItemHandler.getType() == WootSlotItemHandler.Type.INVENTORY) {
                wootSlotItemHandler.setActive(this.activeButton == -1);
                continue;
            }
            wootSlotItemHandler.setActive(this.activeButton != -1);
        }
        super.render(gui, mouseX, mouseY, partialTicks);
        super.renderTooltip(gui, mouseX, mouseY);
        this.renderTooltip(gui, mouseX, mouseY);
        for (WootButton wootButton : this.buttons) {
            wootButton.render(gui, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderBg(@NotNull GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        gui.blit(GUI, 0, 0, 0, 0, this.imageWidth, this.imageHeight);
        this.renderMenuBackground(gui);
        this.renderState(gui);
        if (this.activeButton != -1 && ((HeartContainerMenu)this.menu).getFactoryMob(this.activeButton) == null) {
            this.buttons.get((int)this.activeButton).isViewActive = false;
            this.activeButton = -1;
        }
        if (this.activeButton != -1) {
            this.renderFakeSpawner(gui);
        }
        pose.popPose();
    }

    protected void renderLabels(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        int titleX = 1 + (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        gui.drawString(this.font, this.title, titleX, 6, 0x404040, false);
    }

    protected void renderFluidBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 39, 185, 18, 41);
    }

    protected void renderFluid(@NotNull GuiGraphics gui, int x, int y, FluidStack fluid, int capacity) {
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        int fillHeight = Mth.clamp((int)(fluid.getAmount() * 35 / capacity), (int)0, (int)35);
        int fillY = 35 - fillHeight;
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + 3, y + fillY + 3, 12, fillHeight, fluidTypeExtensions.getTintColor(), false);
        gui.blit(GUI, x + 3, y + 3, 42, 188, 12, 35);
    }

    protected void renderFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid, int capacity) {
        if (this.isHovering(x, y, 18, 41, mouseX, mouseY)) {
            List<MutableComponent> tooltip = capacity == 0 ? List.of(Component.translatable((String)"gui.woot_revived.heart.vitality_cell_missing").setStyle(WootStyles.MACHINE_STYLE)) : List.of(Component.translatable((String)"gui.woot_revived.heart.vitality_cell").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(fluid.getAmount())).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(capacity)).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
            gui.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderSmallFluid(@NotNull GuiGraphics gui, int x, int y, FluidStack fluid) {
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + 3, y + 3, 12, 13, fluidTypeExtensions.getTintColor(), false);
        gui.blit(GUI, x + 3, y + 3, 61, 188, 12, 13);
    }

    protected void renderSmallFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid) {
        if (this.isHovering(x + 1, y + 1, 16, 17, mouseX, mouseY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(List.of(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.fluid").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)(fluid != null && !fluid.isEmpty() ? fluid.getHoverName() : Component.translatable((String)"info.woot_revived.empty"))), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(fluid.getAmount())).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE))));
            if (!fluid.isEmpty()) {
                String modId = BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid()).getNamespace();
                tooltip.add(ModNameHelper.getModName(modId).setStyle(WootStyles.MOD_NAME_STYLE));
            }
            gui.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Nullable
    protected LivingEntity getLivingEntity(int fakeSpawnerIndex) {
        CompoundTag tag = ((HeartContainerMenu)this.menu).getFactoryMobTag(fakeSpawnerIndex);
        if (tag == null) {
            return null;
        }
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)((HeartContainerMenu)this.menu).getLevel(), e -> e);
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity;
    }

    protected boolean isTierEntityValid(@NotNull LivingEntity entity) {
        Tier tier = ((HeartContainerMenu)this.menu).getFactoryTier();
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(entity.getEncodeId());
        return tier.isMobTierValid(mob.getTier());
    }

    protected boolean isTierEntityValid(@NotNull WootFactoryMob<?> mob) {
        Tier tier = ((HeartContainerMenu)this.menu).getFactoryTier();
        return tier.isMobTierValid(mob.getTier());
    }

    protected void renderEntityBoxBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 0, 185, 38, 38);
    }

    protected void renderEntityBox(@NotNull GuiGraphics gui, int x, int y, @Nullable LivingEntity entity) {
        if (entity == null || !this.isTierEntityValid(entity)) {
            MutableComponent invalid = Component.translatable((String)"info.woot_revived.factory.invalid");
            MutableComponent empty = Component.translatable((String)"info.woot_revived.factory.empty");
            Tier tier = ((HeartContainerMenu)this.menu).getFactoryTier();
            float scale = 0.65f;
            PoseStack pose = gui.pose();
            pose.pushPose();
            pose.scale(scale, scale, scale);
            Objects.requireNonNull(this.font);
            float drawY = (32.0f - 9.0f * scale) / 2.0f;
            if (tier == Tier.INVALID || tier == Tier.TIER_1 || entity != null && !this.isTierEntityValid(entity)) {
                float drawX = (32.0f - (float)this.font.width((FormattedText)invalid) * scale) / 2.0f;
                pose.translate(((float)x + drawX + 3.25f) / scale, ((float)y + drawY + 3.25f) / scale, 0.0f);
                gui.drawString(this.font, (Component)invalid, 0, 0, 0x404040, false);
            } else {
                float drawX = (32.0f - (float)this.font.width((FormattedText)empty) * scale) / 2.0f;
                pose.translate(((float)x + drawX + 3.25f) / scale, ((float)y + drawY + 3.25f) / scale, 0.0f);
                gui.drawString(this.font, (Component)empty, 0, 0, 0x404040, false);
            }
            pose.popPose();
            return;
        }
        WootEntityRenderer.render(gui, x, y, entity, 32.0, 3.0, 20.0f);
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)((FluidType)FluidsRegistry.VITALITY_FUEL_FLUID_TYPE.get()));
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + 3, y + 3, 32, 32, fluidTypeExtensions.getTintColor(), true);
    }

    protected void renderEntityTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fakeSpawnerIndex) {
        if (this.isHovering(x + 1, y + 1, 36, 36, mouseX, mouseY)) {
            List<MutableComponent> tooltip;
            WootFactoryMob<?> mob = ((HeartContainerMenu)this.menu).getFactoryMob(fakeSpawnerIndex);
            @Nullable CompoundTag tag = ((HeartContainerMenu)this.menu).getFactoryMobTag(fakeSpawnerIndex);
            Tier tier = ((HeartContainerMenu)this.menu).getFactoryTier();
            if (mob == null || !this.isTierEntityValid(mob)) {
                tooltip = tier == Tier.INVALID ? List.of(Component.translatable((String)"gui.woot_revived.heart.no_tier")) : (tier == Tier.TIER_1 && mob == null ? List.of(Component.translatable((String)"gui.woot_revived.heart.insufficient_tier", (Object[])new Object[]{Component.translatable((String)WootTier.getTranslationKey(Tier.TIER_2))})) : (mob == null ? List.of(Component.translatable((String)"gui.woot_revived.heart.no_secondary")) : List.of(Component.translatable((String)"gui.woot_revived.heart.insufficient_tier", (Object[])new Object[]{Component.translatable((String)WootTier.getTranslationKey(mob.getTier()))}))));
            } else {
                tooltip = new ArrayList<MutableComponent>();
                tooltip.add(mob.getDisplayName(tag, (HolderLookup.Provider)((HeartContainerMenu)this.menu).getLevel().registryAccess()).append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE));
                tooltip.add(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.tier").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)Component.translatable((String)WootTier.getTranslationKey(mob.getTier()))));
                tooltip.add(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.rate").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(mob.getSpawnTickRate())).append((Component)Component.literal((String)"t").setStyle(WootStyles.UNIT_STYLE)));
                tooltip.add(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.cost").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(mob.getVitalityFuelCost())).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
                String modId = BuiltInRegistries.ENTITY_TYPE.getKey(mob.getEntityType()).getNamespace();
                tooltip.add(ModNameHelper.getModName(modId).setStyle(WootStyles.MOD_NAME_STYLE));
                if (((HeartContainerMenu)this.menu).getFactoryIsActive(fakeSpawnerIndex)) {
                    tooltip.add(Component.empty());
                    tooltip.add(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.drained").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(((HeartContainerMenu)this.menu).getFactoryVitalityDrained(fakeSpawnerIndex))).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(((HeartContainerMenu)this.menu).getFactoryVitalityAmount(fakeSpawnerIndex))).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
                    tooltip.add(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.eta").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(String.format("%.1f", Float.valueOf(((HeartContainerMenu)this.menu).getFactoryETA(fakeSpawnerIndex)))).append((Component)Component.literal((String)"s").setStyle(WootStyles.UNIT_STYLE)));
                    tooltip.add(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.usage").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatFloat(((HeartContainerMenu)this.menu).getFactoryRate(fakeSpawnerIndex))).append((Component)Component.literal((String)" mB").setStyle(WootStyles.UNIT_STYLE)).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append((Component)Component.literal((String)"t").setStyle(WootStyles.UNIT_STYLE)));
                }
            }
            gui.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

