/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.heart;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.woot.blocks.cell.CellBlockEntity;
import wootrevived.woot.blocks.factory_upgrade.FactoryUpgradeBlockEntity;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.blocks.heart.HeartBlockEntity;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.render.WootSlot;
import wootrevived.woot.util.render.WootSlotItemHandler;

public class HeartContainerMenu
extends AbstractContainerMenu {
    private final Level level;
    private HeartBlockEntity blockEntity;
    private final ItemStackHandler upgrades = new ItemStackHandler(this, 4){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    };
    private final ItemStackHandler imports = new ItemStackHandler(this, 36){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    };
    public static final int PRIMARY_FAKE_SPAWNER = 0;
    public static final int SECONDARY_FAKE_SPAWNER_0 = 1;
    public static final int SECONDARY_FAKE_SPAWNER_1 = 2;
    public static final int SECONDARY_FAKE_SPAWNER_2 = 3;

    public HeartContainerMenu(int id, Level level, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)BlocksRegistry.HEART_BLOCK_MENU.get(), id);
        this.level = level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof HeartBlockEntity)) {
            return;
        }
        HeartBlockEntity be = (HeartBlockEntity)blockEntity;
        this.blockEntity = be;
        this.createImportSlots();
        this.createUpgradeSlots();
        this.createPlayerInventory(playerInventory);
    }

    public HeartContainerMenu(int windowId, Inventory inv, FriendlyByteBuf data) {
        this(windowId, inv.player.level(), data.readBlockPos(), inv, inv.player);
    }

    private void createImportSlots() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new WootSlotItemHandler((IItemHandler)this.imports, WootSlotItemHandler.Type.HEART_INPUTS, j + i * 9, 8 + j * 18, 106 + i * 18));
            }
        }
    }

    private void createUpgradeSlots() {
        this.addSlot((Slot)new WootSlotItemHandler((IItemHandler)this.upgrades, WootSlotItemHandler.Type.INVENTORY, 0, 11, 78));
        this.addSlot((Slot)new WootSlotItemHandler((IItemHandler)this.upgrades, WootSlotItemHandler.Type.INVENTORY, 1, 29, 78));
        this.addSlot((Slot)new WootSlotItemHandler((IItemHandler)this.upgrades, WootSlotItemHandler.Type.INVENTORY, 2, 47, 78));
        this.addSlot((Slot)new WootSlotItemHandler((IItemHandler)this.upgrades, WootSlotItemHandler.Type.INVENTORY, 3, 65, 78));
    }

    private void createPlayerInventory(Inventory playerInventory) {
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new WootSlot((Container)playerInventory, k, 8 + k * 18, 160));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new WootSlot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }
    }

    public void updateImports(List<ItemStack> stacks) {
        for (int i = 0; i < 36; ++i) {
            this.imports.setStackInSlot(i, i >= stacks.size() ? ItemStack.EMPTY : stacks.get(i));
        }
    }

    public void updateUpgrades() {
        this.upgrades.setStackInSlot(0, this.getUpgrade(0));
        this.upgrades.setStackInSlot(1, this.getUpgrade(3));
        this.upgrades.setStackInSlot(2, this.getUpgrade(2));
        this.upgrades.setStackInSlot(3, this.getUpgrade(1));
    }

    public ItemStack getUpgrade(int index) {
        FactoryUpgradeBlockEntity upgrade = this.blockEntity.getUpgrade(index);
        if (upgrade == null) {
            return ItemStack.EMPTY;
        }
        return upgrade.getUpgradeItemStack();
    }

    public FluidStack getCellFluid() {
        CellBlockEntity cell = this.blockEntity.getCell();
        if (cell == null) {
            return FluidStack.EMPTY;
        }
        return cell.tankHandler.getFluid();
    }

    public int getCellFluidCapacity() {
        CellBlockEntity cell = this.blockEntity.getCell();
        if (cell == null) {
            return 0;
        }
        return cell.tankHandler.getCapacity();
    }

    public Tier getFactoryTier() {
        return this.blockEntity.getFactoryTier();
    }

    public Level getLevel() {
        return this.level;
    }

    @Nullable
    public FakeSpawnerBlockEntity getFakeSpawner(int index) {
        FakeSpawnerBlockEntity fakeSpawner = index == 0 ? this.blockEntity.getPrimaryFakeSpawner() : this.blockEntity.getSecondaryFakeSpawner(index - 1);
        return fakeSpawner;
    }

    @Nullable
    public CompoundTag getFactoryMobTag(int index) {
        FakeSpawnerBlockEntity fakeSpawner = this.getFakeSpawner(index);
        if (fakeSpawner == null || fakeSpawner.isRemoved()) {
            return null;
        }
        return fakeSpawner.getMobTag();
    }

    @Nullable
    public WootFactoryMob<?> getFactoryMob(int index) {
        FakeSpawnerBlockEntity fakeSpawner = this.getFakeSpawner(index);
        if (fakeSpawner == null || fakeSpawner.isRemoved()) {
            return null;
        }
        return fakeSpawner.getMob();
    }

    public int getFactoryVitalityAmount(int index) {
        FakeSpawnerBlockEntity fakeSpawner = this.getFakeSpawner(index);
        if (fakeSpawner == null || fakeSpawner.isRemoved()) {
            return 0;
        }
        return fakeSpawner.getVitalityCost();
    }

    public int getFactoryVitalityDrained(int index) {
        FakeSpawnerBlockEntity fakeSpawner = this.getFakeSpawner(index);
        if (fakeSpawner == null || fakeSpawner.isRemoved()) {
            return 0;
        }
        return fakeSpawner.getTotalDrained();
    }

    public boolean getFactoryIsActive(int index) {
        FakeSpawnerBlockEntity fakeSpawner = this.getFakeSpawner(index);
        if (fakeSpawner == null || fakeSpawner.isRemoved()) {
            return false;
        }
        return fakeSpawner.isActive();
    }

    public float getFactoryETA(int index) {
        FakeSpawnerBlockEntity fakeSpawner = this.getFakeSpawner(index);
        if (fakeSpawner == null || fakeSpawner.isRemoved()) {
            return 0.0f;
        }
        return fakeSpawner.getETA();
    }

    public float getFactoryRate(int index) {
        FakeSpawnerBlockEntity fakeSpawner = this.getFakeSpawner(index);
        if (fakeSpawner == null || fakeSpawner.isRemoved()) {
            return 0.0f;
        }
        return fakeSpawner.getRate();
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return HeartContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlocksRegistry.HEART_BLOCK.get()));
    }
}

