/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.fluid_infuser;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.client.render.fluid_infuser.FluidInfuserContainerMenu;
import wootrevived.woot.config.FluidInfuserConfig;
import wootrevived.woot.util.render.WootContainerScreen;

@OnlyIn(value=Dist.CLIENT)
public class FluidInfuserContainerScreen
extends WootContainerScreen<FluidInfuserContainerMenu> {
    private static final int ENERGY_X = 10;
    private static final int ENERGY_Y = 20;
    private static final int INPUT_FLUID_X = 42;
    private static final int INPUT_FLUID_Y = 20;
    private static final int INPUT_FLUID_COLOR = -14339694;
    private static final int INPUT_SLOT_X = 91;
    private static final int INPUT_SLOT_Y = 24;
    private static final int INPUT_SLOT_COLOR = -11763815;
    private static final int OUTPUT_FLUID_X = 140;
    private static final int OUTPUT_FLUID_Y = 20;
    private static final int OUTPUT_FLUID_COLOR = -6924097;
    private static final int PROGRESS_X = 68;
    private static final int PROGRESS_Y = 44;

    public FluidInfuserContainerScreen(FluidInfuserContainerMenu container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
    }

    @Override
    protected void initButtons() {
        this.createFluidSideButton(42, 20, -14339694, 0, (Component)Component.translatable((String)"info.woot_revived.input_fluid"));
        this.createSlotSideButton(91, 24, -11763815, 2, (Component)Component.translatable((String)"info.woot_revived.input"));
        this.createFluidSideButton(140, 20, -6924097, 1, (Component)Component.translatable((String)"info.woot_revived.output_fluid"));
    }

    @Override
    protected void renderMenuBackground(@NotNull GuiGraphics gui) {
        FluidInfuserContainerScreen.renderSlot(gui, 91, 24, -11763815);
        FluidInfuserContainerScreen.renderEnergyBg(gui, 10, 20);
        FluidInfuserContainerScreen.renderFluidBg(gui, 42, 20);
        FluidInfuserContainerScreen.renderFluidBg(gui, 140, 20);
        FluidInfuserContainerScreen.renderProgressBg(gui, 68, 44);
    }

    @Override
    protected void renderState(@NotNull GuiGraphics gui) {
        FluidInfuserContainerScreen.renderEnergy(gui, 10, 20, ((FluidInfuserContainerMenu)this.menu).getEnergy(), (Integer)FluidInfuserConfig.ENERGY_CAPACITY.get());
        FluidInfuserContainerScreen.renderFluid(gui, 42, 20, ((FluidInfuserContainerMenu)this.menu).getInputFluid(), (Integer)FluidInfuserConfig.INPUT_TANK_CAPACITY.get());
        FluidInfuserContainerScreen.renderFluid(gui, 140, 20, ((FluidInfuserContainerMenu)this.menu).getOutputFluid(), (Integer)FluidInfuserConfig.OUTPUT_TANK_CAPACITY.get());
        FluidInfuserContainerScreen.renderProgress(gui, 68, 44, ((FluidInfuserContainerMenu)this.menu).getProgress());
    }

    protected void renderTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        this.renderEnergyTooltip(gui, mouseX, mouseY, 10, 20, ((FluidInfuserContainerMenu)this.menu).getEnergy(), (Integer)FluidInfuserConfig.ENERGY_CAPACITY.get());
        this.renderFluidTooltip(gui, mouseX, mouseY, 42, 20, ((FluidInfuserContainerMenu)this.menu).getInputFluid(), (Integer)FluidInfuserConfig.INPUT_TANK_CAPACITY.get());
        this.renderFluidTooltip(gui, mouseX, mouseY, 140, 20, ((FluidInfuserContainerMenu)this.menu).getOutputFluid(), (Integer)FluidInfuserConfig.OUTPUT_TANK_CAPACITY.get());
        this.renderProgressTooltip(gui, mouseX, mouseY, 68, 44, ((FluidInfuserContainerMenu)this.menu).getProgress(), ((FluidInfuserContainerMenu)this.menu).getLeftSeconds(), ((FluidInfuserContainerMenu)this.menu).getEnergyProcessTransfer());
    }

    public static void renderProgressBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 177, 81, 65, 24);
    }

    public static void renderProgress(@NotNull GuiGraphics gui, int x, int y, int progress) {
        int fillWidth = Mth.clamp((int)(progress * 65 / 100), (int)0, (int)65);
        gui.blit(GUI, x, y, 177, 106, fillWidth, 25);
    }

    public void renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage) {
        this.renderProgressTooltip(gui, mouseX, mouseY, x, y, 65, 25, progress, eta, usage);
    }

    public static void _renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage, boolean skipHover) {
        FluidInfuserContainerScreen._renderProgressTooltip(gui, mouseX, mouseY, x, y, 65, 25, progress, eta, usage, skipHover);
    }
}

