/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.render.dye_liquifier;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.client.render.dye_liquifier.DyeLiquifierContainerMenu;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.util.render.WootContainerScreen;

@OnlyIn(value=Dist.CLIENT)
public class DyeLiquifierContainerScreen
extends WootContainerScreen<DyeLiquifierContainerMenu> {
    private static final int ENERGY_X = 8;
    private static final int ENERGY_Y = 20;
    private static final int RED_INPUT_SLOT_X = 30;
    private static final int RED_INPUT_SLOT_Y = 28;
    private static final int RED_INPUT_SLOT_COLOR = -2997185;
    private static final int YELLOW_INPUT_SLOT_X = 50;
    private static final int YELLOW_INPUT_SLOT_Y = 28;
    private static final int YELLOW_INPUT_SLOT_COLOR = -1579222;
    private static final int BLUE_INPUT_SLOT_X = 30;
    private static final int BLUE_INPUT_SLOT_Y = 48;
    private static final int BLUE_INPUT_SLOT_COLOR = -10845470;
    private static final int WHITE_INPUT_SLOT_X = 50;
    private static final int WHITE_INPUT_SLOT_Y = 48;
    private static final int WHITE_INPUT_SLOT_COLOR = -9145217;
    private static final int COLOR_BAR_X = 91;
    private static final int RED_COLOR_BAR_Y = 24;
    private static final int YELLOW_COLOR_BAR_Y = 36;
    private static final int BLUE_COLOR_BAR_Y = 48;
    private static final int WHITE_COLOR_BAR_Y = 60;
    private static final int OUTPUT_FLUID_X = 150;
    private static final int OUTPUT_FLUID_Y = 20;
    private static final int OUTPUT_FLUID_COLOR = -6731633;
    private static final int PROGRESS_X = 71;
    private static final int PROGRESS_Y = 26;

    public DyeLiquifierContainerScreen(DyeLiquifierContainerMenu container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
    }

    @Override
    protected void initButtons() {
        this.createSlotSideButton(30, 28, -2997185, 1, (Component)Component.translatable((String)"info.woot_revived.dye_liquifier.red_input"));
        this.createSlotSideButton(50, 28, -1579222, 2, (Component)Component.translatable((String)"info.woot_revived.dye_liquifier.yellow_input"));
        this.createSlotSideButton(30, 48, -10845470, 3, (Component)Component.translatable((String)"info.woot_revived.dye_liquifier.blue_input"));
        this.createSlotSideButton(50, 48, -9145217, 4, (Component)Component.translatable((String)"info.woot_revived.dye_liquifier.white_input"));
        this.createFluidSideButton(150, 20, -6731633, 0, (Component)Component.translatable((String)"info.woot_revived.dye_liquifier.output"));
    }

    @Override
    protected void renderMenuBackground(@NotNull GuiGraphics gui) {
        DyeLiquifierContainerScreen.renderSlot(gui, 30, 28, -2997185);
        DyeLiquifierContainerScreen.renderSlot(gui, 50, 28, -1579222);
        DyeLiquifierContainerScreen.renderSlot(gui, 30, 48, -10845470);
        DyeLiquifierContainerScreen.renderSlot(gui, 50, 48, -9145217);
        DyeLiquifierContainerScreen.renderColorBarBg(gui, 91, 24, DyeColor.RED.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderColorBarBg(gui, 91, 36, DyeColor.YELLOW.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderColorBarBg(gui, 91, 48, DyeColor.BLUE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderColorBarBg(gui, 91, 60, DyeColor.WHITE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderEnergyBg(gui, 8, 20);
        DyeLiquifierContainerScreen.renderFluidBg(gui, 150, 20);
        DyeLiquifierContainerScreen.renderProgressBg(gui, 71, 26);
    }

    @Override
    protected void renderState(@NotNull GuiGraphics gui) {
        DyeLiquifierContainerScreen.renderEnergy(gui, 8, 20, ((DyeLiquifierContainerMenu)this.menu).getEnergy(), (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get());
        DyeLiquifierContainerScreen.renderColorBar(gui, 91, 24, ((DyeLiquifierContainerMenu)this.menu).getRedDyeAmount(), (Integer)DyeLiquifierConfig.RED_TANK_CAPACITY.get(), DyeColor.RED.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderColorBar(gui, 91, 36, ((DyeLiquifierContainerMenu)this.menu).getYellowDyeAmount(), (Integer)DyeLiquifierConfig.YELLOW_TANK_CAPACITY.get(), DyeColor.YELLOW.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderColorBar(gui, 91, 48, ((DyeLiquifierContainerMenu)this.menu).getBlueDyeAmount(), (Integer)DyeLiquifierConfig.BLUE_TANK_CAPACITY.get(), DyeColor.BLUE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderColorBar(gui, 91, 60, ((DyeLiquifierContainerMenu)this.menu).getWhiteDyeAmount(), (Integer)DyeLiquifierConfig.WHITE_TANK_CAPACITY.get(), DyeColor.WHITE.getMapColor().calculateRGBColor(MapColor.Brightness.HIGH));
        DyeLiquifierContainerScreen.renderFluid(gui, 150, 20, ((DyeLiquifierContainerMenu)this.menu).getOutputFluid(), (Integer)DyeLiquifierConfig.OUTPUT_TANK_CAPACITY.get());
        DyeLiquifierContainerScreen.renderProgress(gui, 71, 26, ((DyeLiquifierContainerMenu)this.menu).getProgress());
    }

    protected void renderTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        this.renderEnergyTooltip(gui, mouseX, mouseY, 8, 20, ((DyeLiquifierContainerMenu)this.menu).getEnergy(), (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get());
        this.renderColorBarTooltip(gui, mouseX, mouseY, 91, 24, ((DyeLiquifierContainerMenu)this.menu).getRedDyeAmount(), (Integer)DyeLiquifierConfig.RED_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.red"));
        this.renderColorBarTooltip(gui, mouseX, mouseY, 91, 36, ((DyeLiquifierContainerMenu)this.menu).getYellowDyeAmount(), (Integer)DyeLiquifierConfig.YELLOW_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.yellow"));
        this.renderColorBarTooltip(gui, mouseX, mouseY, 91, 48, ((DyeLiquifierContainerMenu)this.menu).getBlueDyeAmount(), (Integer)DyeLiquifierConfig.BLUE_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.blue"));
        this.renderColorBarTooltip(gui, mouseX, mouseY, 91, 60, ((DyeLiquifierContainerMenu)this.menu).getWhiteDyeAmount(), (Integer)DyeLiquifierConfig.WHITE_TANK_CAPACITY.get(), Component.translatable((String)"info.woot_revived.dye.white"));
        this.renderFluidTooltip(gui, mouseX, mouseY, 150, 20, ((DyeLiquifierContainerMenu)this.menu).getOutputFluid(), (Integer)DyeLiquifierConfig.OUTPUT_TANK_CAPACITY.get());
        this.renderProgressTooltip(gui, mouseX, mouseY, 71, 26, ((DyeLiquifierContainerMenu)this.menu).getProgress(), ((DyeLiquifierContainerMenu)this.menu).getLeftSeconds(), ((DyeLiquifierContainerMenu)this.menu).getEnergyProcessTransfer());
    }

    public static void renderProgressBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 177, 132, 18, 43);
    }

    public static void renderProgress(@NotNull GuiGraphics gui, int x, int y, int progress) {
        int fillWidth = Mth.clamp((int)(progress * 18 / 100), (int)0, (int)18);
        gui.blit(GUI, x, y, 196, 132, fillWidth, 44);
    }

    public void renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage) {
        this.renderProgressTooltip(gui, mouseX, mouseY, x, y, 18, 44, progress, eta, usage);
    }

    public static void _renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage, boolean skipHover) {
        DyeLiquifierContainerScreen._renderProgressTooltip(gui, mouseX, mouseY, x, y, 18, 44, progress, eta, usage, skipHover);
    }
}

