/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.client.model.upgrade_item;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.Woot;
import wootrevived.woot.registries.UpgradeItemsRegistry;

public class DynamicUpgradeItemModel
implements IUnbakedGeometry<DynamicUpgradeItemModel> {
    private static Map<String, UpgradeItemsRegistry.DynamicEntry<?>> upgradeItems = null;

    private DynamicUpgradeItemModel() {
        if (upgradeItems == null) {
            upgradeItems = UpgradeItemsRegistry.getDynamicEntries().stream().collect(Collectors.toMap(c -> c.item().getId().withPrefix("item/").toString(), c -> c));
        }
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        UpgradeItemsRegistry.DynamicEntry<?> entry = upgradeItems.get(context.getModelName());
        if (entry == null) {
            throw new IllegalStateException("The upgrade item should be dynamic!");
        }
        String name = UpgradeItemsRegistry.getNameFromItem(entry.item());
        if (!UpgradeItemsRegistry.isDynamic(name)) {
            throw new IllegalStateException("The upgrade item should be dynamic!");
        }
        return this.bake(entry, context, baker, spriteGetter, modelState, overrides);
    }

    public <T extends Enum<T>> BakedModel bake(UpgradeItemsRegistry.DynamicEntry<T> entry, IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        WootUpgradeItem item = (WootUpgradeItem)((Object)entry.item().get());
        String name = UpgradeItemsRegistry.getNameFromItem(entry.item());
        EnumMap<T, BakedModel> cache = new EnumMap<T, BakedModel>(entry.variantClass());
        UpgradeItemOverrideHandler<T> upgradeOverrides = new UpgradeItemOverrideHandler<T>(cache, item, overrides);
        for (Enum variant : (Enum[])entry.variantClass().getEnumConstants()) {
            Material material = new Material(InventoryMenu.BLOCK_ATLAS, Woot.location("item/upgrade_item_" + ((StringRepresentable)variant).getSerializedName() + "_" + name));
            TextureAtlasSprite sprite = spriteGetter.apply(material);
            CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)sprite, upgradeOverrides, (ItemTransforms)context.getTransforms());
            RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.translucent(), NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
            cache.put((T)variant, modelBuilder.build());
        }
        return (BakedModel)cache.get(item.getVariant(null));
    }

    private static final class UpgradeItemOverrideHandler<T extends Enum<T>>
    extends ItemOverrides {
        private final ItemOverrides nested;
        private final WootUpgradeItem<T> item;
        private final EnumMap<T, BakedModel> cache;

        private UpgradeItemOverrideHandler(EnumMap<T, BakedModel> cache, WootUpgradeItem<T> item, ItemOverrides nested) {
            this.nested = nested;
            this.item = item;
            this.cache = cache;
        }

        public BakedModel resolve(@NotNull BakedModel originalModel, @NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.resolve(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            T variant = this.item.getVariant((MutableDataComponentHolder)stack);
            BakedModel model = this.cache.get(variant);
            return model != null ? model : originalModel;
        }
    }

    public static final class Loader
    implements IGeometryLoader<DynamicUpgradeItemModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public DynamicUpgradeItemModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            return new DynamicUpgradeItemModel();
        }
    }
}

