/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.stygian_anvil;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.fake_spawner.FakeSpawnerBlockEntity;
import wootrevived.woot.blocks.stygian_anvil.StygianAnvilBlock;
import wootrevived.woot.items.mob_shard.MobShardItem;
import wootrevived.woot.recipes.stygian_anvil.StygianAnvilRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootRecipeInput;

public class StygianAnvilBlockEntity
extends BlockEntity {
    public final ItemStackHandler inventoryHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            StygianAnvilBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == BASE_SLOT) {
                if (stack.getItem() instanceof MobShardItem) {
                    return MobShardItem.isFullyProgrammed(stack);
                }
                return StygianAnvilRecipe.Validator.isBaseValid(stack);
            }
            return StygianAnvilRecipe.Validator.isIngredientValid(stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public static int BASE_SLOT = 0;
    public static int INGREDIENT_1_SLOT = 1;
    public static int INGREDIENT_2_SLOT = 2;
    public static int INGREDIENT_3_SLOT = 3;
    public static int INGREDIENT_4_SLOT = 4;

    public StygianAnvilBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.STYGIAN_ANVIL_BLOCK_ENTITY.get(), pos, state);
    }

    public IItemHandler getInventory() {
        return this.inventoryHandler;
    }

    public static IItemHandler getItemHandlerCapability(StygianAnvilBlockEntity blockEntity, Direction side) {
        return blockEntity.getInventory();
    }

    public ItemStack[] getIngredients() {
        return new ItemStack[]{this.inventoryHandler.getStackInSlot(INGREDIENT_1_SLOT), this.inventoryHandler.getStackInSlot(INGREDIENT_2_SLOT), this.inventoryHandler.getStackInSlot(INGREDIENT_3_SLOT), this.inventoryHandler.getStackInSlot(INGREDIENT_4_SLOT)};
    }

    public void dropContents(Level level, BlockPos pos) {
        for (int slot = 0; slot < this.inventoryHandler.getSlots(); ++slot) {
            ItemStack stack = this.inventoryHandler.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
        this.setChanged();
    }

    public void dropItem(Player player, InteractionHand hand) {
        ItemStack itemStack = ItemStack.EMPTY;
        for (int slot = this.inventoryHandler.getSlots() - 1; slot >= 0; --slot) {
            ItemStack stack = this.inventoryHandler.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            itemStack = stack;
            this.inventoryHandler.setStackInSlot(slot, ItemStack.EMPTY);
            break;
        }
        if (!itemStack.isEmpty()) {
            this.setChanged();
            player.setItemInHand(hand, itemStack);
        }
    }

    public ItemStack tryCraft(Player playerEntity, boolean simulate) {
        if (!((StygianAnvilBlock)((Object)BlocksRegistry.STYGIAN_ANVIL_BLOCK.get())).isAnvilHot(this.level, this.getBlockPos())) {
            if (playerEntity != null) {
                playerEntity.displayClientMessage((Component)Component.translatable((String)"chat.woot_revived.anvil.cold"), true);
            }
            return ItemStack.EMPTY;
        }
        RecipeHolder recipeHolder = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.ANVIL_RECIPE_TYPE.get(), (RecipeInput)new WootRecipeInput(Either.left((Object)this.inventoryHandler.getStackInSlot(BASE_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_1_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_2_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_3_SLOT)), Either.left((Object)this.inventoryHandler.getStackInSlot(INGREDIENT_4_SLOT))), this.level).orElse(null);
        if (recipeHolder == null) {
            return ItemStack.EMPTY;
        }
        ItemStack output = ((StygianAnvilRecipe)recipeHolder.value()).getOutput();
        ItemStack baseStack = this.inventoryHandler.getStackInSlot(BASE_SLOT);
        if (baseStack.getItem() instanceof MobShardItem) {
            if (!MobShardItem.isFullyProgrammed(baseStack)) {
                return ItemStack.EMPTY;
            }
            CompoundTag mobTag = MobShardItem.getProgrammedMob(baseStack);
            if (mobTag == null) {
                return ItemStack.EMPTY;
            }
            output = FakeSpawnerBlockEntity.getItemStack(mobTag);
        }
        if (!simulate) {
            for (int slot = 0; slot < this.inventoryHandler.getSlots(); ++slot) {
                ItemStack item = this.inventoryHandler.getStackInSlot(slot);
                if (item.getItem().hasCraftingRemainingItem(item)) {
                    this.inventoryHandler.setStackInSlot(slot, item.getItem().getCraftingRemainingItem(item));
                    continue;
                }
                this.inventoryHandler.setStackInSlot(slot, ItemStack.EMPTY);
            }
            this.setChanged();
        }
        return output;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("InputInventory", (Tag)this.inventoryHandler.serializeNBT(provider));
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("InputInventory")) {
            this.inventoryHandler.deserializeNBT(provider, tag.getCompound("InputInventory"));
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

