/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.magmator;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.stygian_anvil.StygianAnvilBlockEntity;
import wootrevived.woot.config.MagmatorConfig;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.common.RedstoneMode;

public class MagmatorBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    private final int tickRate;
    private StygianAnvilBlockEntity anvil = null;
    private int delayTick;
    private RedstoneMode redstoneMode = RedstoneMode.ALWAYS_ON;
    private boolean lastRedstoneState = false;
    private final IItemHandler handler = new AnvilHandler(this);

    public MagmatorBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
        this.tickRate = entity == BlocksRegistry.COPPER_MAGMATOR_BLOCK_ENTITY.get() ? (Integer)MagmatorConfig.COPPER_TICK_RATE.get() : (entity == BlocksRegistry.IRON_MAGMATOR_BLOCK_ENTITY.get() ? (Integer)MagmatorConfig.IRON_TICK_RATE.get() : (entity == BlocksRegistry.GOLD_MAGMATOR_BLOCK_ENTITY.get() ? (Integer)MagmatorConfig.GOLD_TICK_RATE.get() : (entity == BlocksRegistry.DIAMOND_MAGMATOR_BLOCK_ENTITY.get() ? (Integer)MagmatorConfig.DIAMOND_TICK_RATE.get() : (entity == BlocksRegistry.NETHERITE_MAGMATOR_BLOCK_ENTITY.get() ? (Integer)MagmatorConfig.NETHERITE_TICK_RATE.get() : 1))));
        this.delayTick = this.tickRate;
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof MagmatorBlockEntity) {
            MagmatorBlockEntity magmatorBlockEntity = (MagmatorBlockEntity)blockEntity;
            magmatorBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity upEntity = level.getBlockEntity(pos.relative(Direction.UP));
        if (!(upEntity instanceof StygianAnvilBlockEntity)) {
            this.anvil = null;
            return;
        }
        StygianAnvilBlockEntity stygianAnvilEntity = (StygianAnvilBlockEntity)upEntity;
        this.anvil = stygianAnvilEntity;
        if (this.isDisabled()) {
            return;
        }
        if (this.delayTick-- != 0) {
            return;
        }
        this.delayTick = this.tickRate;
        for (Direction direction : Direction.values()) {
            ItemStack inserted;
            ItemStack stack;
            IItemHandler handler;
            if (direction == Direction.UP || (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite())) == null || (stack = this.anvil.tryCraft(null, true)).isEmpty() || !(inserted = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false)).isEmpty()) continue;
            this.anvil.tryCraft(null, false);
            return;
        }
    }

    private boolean isDisabled() {
        if (this.redstoneMode == RedstoneMode.ALWAYS_ON) {
            return false;
        }
        boolean current = this.level.hasNeighborSignal(this.getBlockPos());
        if (this.redstoneMode != RedstoneMode.ONCE) {
            return this.redstoneMode == RedstoneMode.WITH_SIGNAL != current;
        }
        boolean risingEdge = !this.lastRedstoneState && current;
        this.lastRedstoneState = current;
        return !risingEdge;
    }

    public void nextRedstoneMode(Player player) {
        this.redstoneMode = this.redstoneMode.getNext();
        this.setChanged();
        player.displayClientMessage(this.redstoneMode.getComponent(), true);
    }

    public static IItemHandler getItemHandlerCapability(MagmatorBlockEntity blockEntity, Direction side) {
        return blockEntity.handler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("RedstoneMode", this.redstoneMode.ordinal());
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.redstoneMode = RedstoneMode.byIndex(tag.getInt("RedstoneMode"));
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    private static class AnvilHandler
    implements IItemHandler {
        MagmatorBlockEntity entity;

        private AnvilHandler(MagmatorBlockEntity entity) {
            this.entity = entity;
        }

        public int getSlots() {
            return this.entity.anvil == null ? 0 : this.entity.anvil.getInventory().getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int i) {
            return this.entity.anvil == null ? ItemStack.EMPTY : this.entity.anvil.getInventory().getStackInSlot(i);
        }

        @NotNull
        public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean b) {
            return this.entity.anvil == null ? itemStack : this.entity.anvil.getInventory().insertItem(i, itemStack, b);
        }

        @NotNull
        public ItemStack extractItem(int i, int i1, boolean b) {
            return this.entity.anvil == null ? ItemStack.EMPTY : this.entity.anvil.getInventory().extractItem(i, i1, b);
        }

        public int getSlotLimit(int i) {
            return this.entity.anvil == null ? 0 : this.entity.anvil.getInventory().getSlotLimit(i);
        }

        public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
            return this.entity.anvil != null && this.entity.anvil.getInventory().isItemValid(i, itemStack);
        }
    }
}

