/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.magmator;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.magmator.MagmatorBlockEntity;

public class MagmatorBlock
extends Block
implements EntityBlock {
    protected final Supplier<BlockEntityType<?>> entity;
    protected StateDefinition<Block, BlockState> magmatorStateDefinition;

    public MagmatorBlock(Supplier<BlockEntityType<?>> entity) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f));
        this.entity = entity;
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition(stateDefinitionBuilder);
        this.magmatorStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)this.getStateDefinition().any());
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.magmatorStateDefinition;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return this.entity.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return MagmatorBlockEntity::ticker;
    }

    public static class State
    extends BlockState {
        public State(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public ItemInteractionResult useItemOn(@NotNull ItemStack heldItem, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            BlockEntity be = level.getBlockEntity(hit.getBlockPos());
            if (player.isShiftKeyDown() && be instanceof MagmatorBlockEntity) {
                MagmatorBlockEntity entity = (MagmatorBlockEntity)be;
                entity.nextRedstoneMode(player);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }

        @NotNull
        public InteractionResult useWithoutItem(@NotNull Level level, @NotNull Player player, @NotNull BlockHitResult hit) {
            return this.useItemOn(ItemStack.EMPTY, level, player, InteractionHand.MAIN_HAND, hit).result();
        }
    }
}

