/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.layout;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.layout.LayoutBlockEntity;
import wootrevived.woot.multiblock.patterns.Pattern;
import wootrevived.woot.multiblock.patterns.Patterns;
import wootrevived.woot.registries.BlocksRegistry;

public class LayoutBlock
extends Block
implements EntityBlock {
    protected StateDefinition<Block, BlockState> layoutStateDefinition;

    public LayoutBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.layoutStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.layoutStateDefinition;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.LAYOUT_BLOCK_ENTITY.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return LayoutBlockEntity::ticker;
    }

    public static class State
    extends BlockState {
        public State(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation rotation) {
            return (BlockState)this.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }

        @NotNull
        public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.isClientSide || hand == InteractionHand.OFF_HAND) {
                return super.useItemOn(stack, level, player, hand, hit);
            }
            if (!player.getMainHandItem().isEmpty()) {
                return ItemInteractionResult.FAIL;
            }
            BlockEntity blockEntity = level.getBlockEntity(hit.getBlockPos());
            if (blockEntity instanceof LayoutBlockEntity) {
                LayoutBlockEntity layoutBlockEntity = (LayoutBlockEntity)blockEntity;
                layoutBlockEntity.setNextTier();
            }
            return ItemInteractionResult.SUCCESS;
        }

        @NotNull
        public InteractionResult useWithoutItem(@NotNull Level level, @NotNull Player player, @NotNull BlockHitResult hit) {
            return this.useItemOn(ItemStack.EMPTY, level, player, InteractionHand.MAIN_HAND, hit).result();
        }

        public void onRemove(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
            if (!level.isClientSide) {
                Direction facing = (Direction)this.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockPos layoutPos = switch (facing) {
                    case Direction.NORTH -> pos.offset(0, 10, -1);
                    case Direction.SOUTH -> pos.offset(0, 10, 1);
                    case Direction.EAST -> pos.offset(1, 10, 0);
                    case Direction.WEST -> pos.offset(-1, 10, 0);
                    default -> pos;
                };
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_1.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_2.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_3.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_4.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
                for (Pattern.PatternBlock patternBlock : Patterns.TIER_5.patterns.get(facing)) {
                    LayoutBlockEntity.removePatternBlock(level, layoutPos, patternBlock);
                }
            }
            super.onRemove(level, pos, newState, movedByPiston);
        }
    }
}

