/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.ingredient_import;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.data.IngredientImportData;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.handlers.WootImportFluidHandler;
import wootrevived.woot.util.handlers.WootImportItemHandler;

public class IngredientImportBlockEntity
extends FactoryBlockBaseEntity {
    private WootImportItemHandler itemHandler = new WootImportItemHandler();
    private WootImportFluidHandler fluidHandler = new WootImportFluidHandler();

    public IngredientImportBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.IMPORT_BLOCK_ENTITY.get(), pos, state);
    }

    public void setImportItem(int index, List<ItemStack> importItem) {
        this.itemHandler.setImportItem(index, importItem);
    }

    public void setImportFluid(int index, List<FluidStack> importFluid) {
        this.fluidHandler.setImportFluid(index, importFluid);
    }

    public boolean isImportValid(int index) {
        return this.itemHandler.isImportValid(index) && this.fluidHandler.isImportValid(index);
    }

    public void consumeImports(int index) {
        this.itemHandler.consume(index);
        this.fluidHandler.consume(index);
    }

    public void extractNeighbors() {
        for (Direction direction : Direction.values()) {
            IFluidHandler neighborFluidHandler;
            if (direction == Direction.UP || direction == Direction.DOWN) continue;
            BlockPos blockPos = this.getBlockPos().relative(direction);
            IItemHandler neighborItemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, (Object)direction.getOpposite());
            if (neighborItemHandler != null) {
                for (int i = 0; i < neighborItemHandler.getSlots(); ++i) {
                    ItemStack extracted;
                    ItemStack stack = neighborItemHandler.getStackInSlot(i);
                    ItemStack result = this.itemHandler.insertItem(i, stack, true);
                    if (result.getCount() >= stack.getCount() || (extracted = neighborItemHandler.extractItem(i, stack.getCount() - result.getCount(), false)).isEmpty()) continue;
                    this.itemHandler.insertItem(i, extracted, false);
                }
            }
            if ((neighborFluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos, (Object)direction.getOpposite())) == null) continue;
            for (int i = 0; i < neighborFluidHandler.getTanks(); ++i) {
                FluidStack drained;
                FluidStack stack = neighborFluidHandler.getFluidInTank(i);
                int filled = this.fluidHandler.fill(stack, IFluidHandler.FluidAction.SIMULATE);
                if (filled <= 0 || (drained = neighborFluidHandler.drain(new FluidStack(stack.getFluid(), filled), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
                this.fluidHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public static IItemHandler getItemHandlerCapability(IngredientImportBlockEntity blockEntity, Direction side) {
        return blockEntity.itemHandler;
    }

    public static IFluidHandler getFluidHandlerCapability(IngredientImportBlockEntity blockEntity, Direction side) {
        return blockEntity.fluidHandler;
    }

    private IngredientImportData.Component getComponent() {
        return new IngredientImportData.Component(this.itemHandler, this.fluidHandler);
    }

    private void setComponent(IngredientImportData.Component component) {
        this.itemHandler = component.itemHandler();
        this.fluidHandler = component.fluidHandler();
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        IngredientImportData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        IngredientImportData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }
}

