/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.fluid_infuser;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.fluid_infuser.FluidInfuserContainerMenu;
import wootrevived.woot.config.FluidInfuserConfig;
import wootrevived.woot.data.FluidInfuserData;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ComponentsRegistry;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;
import wootrevived.woot.util.recipes.WootRecipeInput;

public class FluidInfuserBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private final List<EnumMap<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<EnumMap<MachineSide, MachineSideProperty>>(3);
    public static final int INPUT_FLUID_PROPERTY = 0;
    public static final int OUTPUT_FLUID_PROPERTY = 1;
    public static final int INGREDIENT_PROPERTY = 2;
    public final WootItemStackHandler inventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            FluidInfuserBlockEntity.this.onContentsChanged(slot);
            FluidInfuserBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return FluidInfuserRecipe.Validator.isCatalystValid(stack);
        }
    };
    public static final int INPUT_SLOT = 0;
    private FluidInfuserRecipe recipe = null;

    public FluidInfuserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FLUID_INFUSER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 3; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof FluidInfuserBlockEntity) {
            FluidInfuserBlockEntity fluidInfuserBlockEntity = (FluidInfuserBlockEntity)blockEntity;
            fluidInfuserBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    @Override
    public void tick(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.tick(level, pos, state, blockEntity);
        if (level.isClientSide) {
            return;
        }
        this.tickItem(this.inventoryHandler, pos, side -> this.getProperties((Direction)side).getIngredientProperty());
        this.tickFluid(this.inputTankHandler, pos, (Integer)FluidInfuserConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getInputFluidProperty());
        this.tickFluid(this.outputTankHandler, pos, (Integer)FluidInfuserConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getOutputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventoryHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    public static IItemHandler getItemHandlerCapability(FluidInfuserBlockEntity blockEntity, @Nullable Direction side) {
        if (side == null) {
            return blockEntity.inventoryHandler;
        }
        Properties properties = blockEntity.getProperties(side);
        return new WootItemHandlerWrapper().addHandler(blockEntity.inventoryHandler, properties::getIngredientProperty);
    }

    public static IFluidHandler getFluidHandlerCapability(FluidInfuserBlockEntity blockEntity, @Nullable Direction side) {
        if (side == null) {
            return new WootFluidHandlerWrapper().addHandler(blockEntity.inputTankHandler, () -> MachineSideProperty.ENABLED).addHandler(blockEntity.outputTankHandler, () -> MachineSideProperty.ENABLED);
        }
        Properties properties = blockEntity.getProperties(side);
        return new WootFluidHandlerWrapper().addHandler(blockEntity.outputTankHandler, properties::getOutputFluidProperty).addHandler(blockEntity.inputTankHandler, properties::getInputFluidProperty);
    }

    private FluidInfuserData.Component getComponent() {
        return new FluidInfuserData.Component(this.energyHandler.getEnergyStored(), this.getInputTank().getFluid(), this.getOutputTank().getFluid(), this.getAllMachineSidesProperties());
    }

    private void setComponent(FluidInfuserData.Component component) {
        this.energyHandler.setEnergy(component.energy());
        this.getInputTank().setFluid(component.inputFluid());
        this.getOutputTank().setFluid(component.outputFluid());
        this.setAllMachineSidesProperties(component.listMachineProperties());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        FluidInfuserData.Component component = (FluidInfuserData.Component)input.get(ComponentsRegistry.FLUID_INFUSER_DATA);
        if (component == null) {
            return;
        }
        this.setComponent(component);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(ComponentsRegistry.FLUID_INFUSER_DATA, (Object)this.getComponent());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("InputInventory", (Tag)this.inventoryHandler.serializeNBT(provider));
        FluidInfuserData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("InputInventory")) {
            this.inventoryHandler.deserializeNBT(provider, tag.getCompound("InputInventory"));
        }
        FluidInfuserData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(0);
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.inventoryHandler.insertItem(0, ItemStack.EMPTY, false);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot_revived.fluid_infuser.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new FluidInfuserContainerMenu(containerId, this.level, this.getBlockPos(), playerInventory, player);
    }

    @Override
    public EnumMap<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<EnumMap<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<EnumMap<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
        this.recipe = null;
    }

    @Override
    protected int getRecipeEnergy() {
        return this.recipe != null ? this.recipe.getEnergy() : 0;
    }

    @Override
    protected void processFinished() {
        if (this.recipe == null) {
            this.getRecipe();
        }
        if (this.recipe == null) {
            this.processOff();
            return;
        }
        FluidInfuserRecipe recipe = this.recipe;
        ItemStack item = this.inventoryHandler.getStackInSlot(0);
        if (item.getItem().hasCraftingRemainingItem(item)) {
            this.inventoryHandler.setStackInSlot(0, item.getItem().getCraftingRemainingItem(item));
        } else {
            int ingredientAmount = recipe.ingredientCount(this.inventoryHandler.getStackInSlot(0).getItem());
            this.inventoryHandler.extractItem(0, ingredientAmount, false);
        }
        this.inputTankHandler.drain(recipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        this.outputTankHandler.fill(recipe.getOutputFluid(), IFluidHandler.FluidAction.EXECUTE);
        this.setChanged();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.recipe == null) {
            return false;
        }
        if (!this.outputTankHandler.isEmpty() && this.outputTankHandler.getFluid().getFluid() != this.recipe.getOutputFluid().getFluid()) {
            return false;
        }
        if (this.outputTankHandler.getFluidAmount() + this.recipe.getOutputFluid().getAmount() > this.outputTankHandler.getCapacity()) {
            return false;
        }
        return this.inputTankHandler.getFluid().getAmount() >= this.recipe.getInputFluid().getAmount();
    }

    private void getRecipe() {
        this.clearRecipe();
        FluidStack inFluid = this.inputTankHandler.getFluid();
        if (inFluid.isEmpty()) {
            this.clearRecipe();
            return;
        }
        ItemStack catalyst = this.inventoryHandler.getStackInSlot(0);
        if (catalyst.isEmpty()) {
            this.clearRecipe();
            return;
        }
        RecipeHolder recipeHolder = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.FLUID_INFUSER_RECIPE_TYPE.get(), (RecipeInput)new WootRecipeInput(Either.right((Object)this.inputTankHandler.getFluid()), Either.left((Object)this.inventoryHandler.getStackInSlot(0))), this.level).orElse(null);
        this.recipe = recipeHolder == null ? null : (FluidInfuserRecipe)recipeHolder.value();
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)FluidInfuserConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)FluidInfuserConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)FluidInfuserConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return (Integer)FluidInfuserConfig.INPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasInputFluidCapability() {
        return true;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return FluidInfuserRecipe.Validator::isFluidValid;
    }

    @Override
    public int getOutputTankCapacity() {
        return (Integer)FluidInfuserConfig.OUTPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return true;
    }

    public record Properties(FluidInfuserBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getIngredientProperty() {
            return this.entity.directionsProperties.get(2).get((Object)this.machineSide);
        }

        public MachineSideProperty getInputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputFluidProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }
    }
}

