/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.fake_spawner;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.woot.data.FakeSpawnerData;
import wootrevived.woot.network.WootFakeSpawnerUpdate;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ComponentsRegistry;
import wootrevived.woot.registries.WootFactoryMobsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class FakeSpawnerBlockEntity
extends FactoryBlockBaseEntity {
    private CompoundTag mobTag = null;
    public int index;
    private int vitalityCost = 0;
    private int totalDrained = 0;
    private double perTickRatio = 0.0;
    private double accumulator = 0.0;
    private int numOfSim = 0;
    protected RedstoneMode redstoneMode = RedstoneMode.ALWAYS_ON;
    private boolean lastRedstoneState = false;

    public FakeSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FAKE_SPAWNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public CompoundTag getMobTag() {
        return this.mobTag;
    }

    @Nullable
    public WootFactoryMob<?> getMob() {
        if (this.mobTag == null) {
            return null;
        }
        return WootFactoryMobsRegistry.getFactoryMob(this.mobTag);
    }

    public int getNumberOfSimulations() {
        return this.numOfSim;
    }

    public int getVitalityCost() {
        return this.vitalityCost;
    }

    public int getTotalDrained() {
        return this.totalDrained;
    }

    public float getETA() {
        return (float)(((double)(this.vitalityCost - this.totalDrained) - this.accumulator) / (this.perTickRatio * 20.0));
    }

    public float getRate() {
        return (float)this.perTickRatio;
    }

    public boolean setActive(int rate, int cost, int numOfSim) {
        if (this.isDisabled()) {
            return false;
        }
        this.perTickRatio = (double)cost / (double)rate;
        this.accumulator = 0.0;
        this.vitalityCost = cost;
        this.totalDrained = 0;
        this.numOfSim = numOfSim;
        this.setChanged();
        return true;
    }

    public boolean isActive() {
        return this.totalDrained < this.vitalityCost;
    }

    public boolean tick(WootFluidTankHandler tank) {
        if (this.getMob() == null || this.getMob().isBlacklisted() || !this.isActive()) {
            return false;
        }
        if (this.redstoneMode != RedstoneMode.ONCE && this.isDisabled()) {
            return false;
        }
        this.accumulator += this.perTickRatio;
        int drainAmount = (int)this.accumulator;
        this.accumulator -= (double)drainAmount;
        if (drainAmount <= 0) {
            return false;
        }
        FluidStack simulate = tank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
        if (simulate.getAmount() < drainAmount) {
            this.accumulator += (double)drainAmount - this.perTickRatio;
            this.setChanged();
            return false;
        }
        FluidStack consumed = tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
        this.totalDrained += consumed.getAmount();
        if (this.totalDrained >= this.vitalityCost) {
            this.vitalityCost = 0;
            this.totalDrained = 0;
            this.setChanged();
            return true;
        }
        this.setChanged();
        return false;
    }

    public Tier getTier() {
        if (this.mobTag == null) {
            return Tier.INVALID;
        }
        if (!WootFactoryMobsRegistry.hasFactoryMob(this.mobTag)) {
            return Tier.INVALID;
        }
        WootFactoryMob<?> mob = WootFactoryMobsRegistry.getFactoryMob(this.mobTag);
        return mob.getTier();
    }

    public static ItemStack getItemStack(CompoundTag tag) {
        ItemStack itemStack = ((Block)BlocksRegistry.FAKE_SPAWNER_BLOCK.get()).asItem().getDefaultInstance();
        itemStack.applyComponents(DataComponentPatch.builder().set((DataComponentType)ComponentsRegistry.FAKE_SPAWNER_DATA.get(), (Object)new FakeSpawnerData.Component(Optional.ofNullable(tag))).build());
        return itemStack;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
    }

    protected boolean isDisabled() {
        if (this.redstoneMode == RedstoneMode.ALWAYS_ON) {
            return false;
        }
        boolean current = this.level.hasNeighborSignal(this.getBlockPos());
        if (this.redstoneMode != RedstoneMode.ONCE) {
            return this.redstoneMode == RedstoneMode.WITH_SIGNAL != current;
        }
        boolean risingEdge = !this.lastRedstoneState && current;
        this.lastRedstoneState = current;
        return !risingEdge;
    }

    private FakeSpawnerData.Component getComponent() {
        return new FakeSpawnerData.Component(Optional.ofNullable(this.getMobTag()));
    }

    public void setComponent(FakeSpawnerData.Component component) {
        this.mobTag = component.mobTag().orElse(null);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        FakeSpawnerData.Component component = (FakeSpawnerData.Component)input.get(ComponentsRegistry.FAKE_SPAWNER_DATA);
        if (component == null) {
            return;
        }
        this.setComponent(component);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(ComponentsRegistry.FAKE_SPAWNER_DATA, (Object)this.getComponent());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("RedstoneMode", this.redstoneMode.ordinal());
        tag.putInt("NumOfSim", this.numOfSim);
        tag.putInt("VitalityCost", this.vitalityCost);
        tag.putInt("TotalDrained", this.totalDrained);
        tag.putDouble("PerTickRatio", this.perTickRatio);
        tag.putDouble("Accumulator", this.accumulator);
        FakeSpawnerData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.redstoneMode = RedstoneMode.byIndex(tag.getInt("RedstoneMode"));
        this.numOfSim = tag.getInt("NumOfSim");
        this.vitalityCost = tag.getInt("VitalityCost");
        this.totalDrained = tag.getInt("TotalDrained");
        this.perTickRatio = tag.getDouble("PerTickRatio");
        this.accumulator = tag.getDouble("Accumulator");
        FakeSpawnerData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void sendNewState() {
        PacketDistributor.sendToServer((CustomPacketPayload)new WootFakeSpawnerUpdate(this.getBlockPos(), this.redstoneMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleNewState(WootFakeSpawnerUpdate update) {
        if (update.redstoneMode() != null) {
            this.redstoneMode = update.redstoneMode();
        }
        this.setChanged();
    }

    public boolean canPlayerAccess(ServerPlayer player) {
        return !(player.distanceToSqr((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) > 64.0);
    }
}

