/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.factory_upgrade;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.woot.client.model.factory_upgrade.FactoryUpgradeBakedModel;
import wootrevived.woot.data.FactoryUpgradeData;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.UpgradeItemsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;

public class FactoryUpgradeBlockEntity
extends FactoryBlockBaseEntity {
    private WootUpgradeItem<?> upgradeItem = null;
    private ItemStack upgradeStack = ItemStack.EMPTY;

    public FactoryUpgradeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.FACTORY_UPGRADE_BLOCK_ENTITY.get(), pos, state);
    }

    public void applyGenerationProperties(WootGenerationProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.applyGenerationProperties(properties, (MutableDataComponentHolder)this.upgradeStack);
            this.setChanged();
        }
    }

    public void applySpawnProperties(WootSpawnProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.applySpawnProperties(properties, (MutableDataComponentHolder)this.upgradeStack);
            this.setChanged();
        }
    }

    public void modifyDrops(WootDropsProperties properties) {
        if (this.upgradeItem != null) {
            this.upgradeItem.modifyDrops(properties, (MutableDataComponentHolder)this.upgradeStack);
            this.setChanged();
        }
    }

    public String getUpgradeItemName() {
        return this.upgradeItem == null ? "" : UpgradeItemsRegistry.getNameFromItem(this.upgradeItem);
    }

    public ItemStack getUpgradeItemStack() {
        return this.upgradeStack;
    }

    public ItemInteractionResult interactUpgrade(ItemStack stack, Level level, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.upgradeItem == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemInteractionResult result = this.upgradeItem.interact((MutableDataComponentHolder)this.upgradeStack, stack, level, player, hand, hit);
        this.setChanged();
        return result;
    }

    public void addUpgrade(Level level, Player player, InteractionHand hand, ItemStack stack, WootUpgradeItem<?> newUpgradeItem) {
        ItemStack oldStack = this.upgradeStack;
        if (this.upgradeItem != null) {
            this.upgradeItem.deinitDataComponents((MutableDataComponentHolder)oldStack, level, this.getBlockPos());
        }
        this.upgradeItem = newUpgradeItem;
        this.upgradeStack = stack.copyWithCount(1);
        newUpgradeItem.initDataComponents((MutableDataComponentHolder)this.upgradeStack, level, this.getBlockPos());
        this.setChanged();
        player.swing(hand);
        if (!player.isCreative()) {
            stack.shrink(1);
            if (!oldStack.isEmpty()) {
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, oldStack);
                } else {
                    this.dropItem(level, player.getOnPos().above(), oldStack);
                }
            }
        }
    }

    public void removeUpgrade(Level level, Player player, InteractionHand hand) {
        ItemStack oldStack = this.upgradeStack;
        if (this.upgradeItem != null) {
            this.upgradeItem.deinitDataComponents((MutableDataComponentHolder)oldStack, level, this.getBlockPos());
        }
        this.upgradeItem = null;
        this.upgradeStack = ItemStack.EMPTY;
        this.setChanged();
        player.swing(hand);
        if (!oldStack.isEmpty()) {
            if (player.getItemInHand(hand).isEmpty()) {
                player.setItemInHand(hand, oldStack);
            } else {
                this.dropItem(level, player.getOnPos().above(), oldStack);
            }
        }
    }

    public void dropItem(Level level, BlockPos pos) {
        if (this.upgradeStack.isEmpty()) {
            return;
        }
        if (this.upgradeItem != null) {
            this.upgradeItem.deinitDataComponents((MutableDataComponentHolder)this.upgradeStack, level, this.getBlockPos());
        }
        this.dropItem(level, pos, this.upgradeStack);
    }

    public void dropItem(Level level, BlockPos pos, ItemStack stack) {
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
    }

    private FactoryUpgradeData.Component getComponent() {
        return new FactoryUpgradeData.Component(Optional.ofNullable(this.getUpgradeItemName()), Optional.of(this.upgradeStack));
    }

    private void setComponent(FactoryUpgradeData.Component component) {
        component.upgradeItem().ifPresentOrElse(item -> {
            this.upgradeItem = !item.isEmpty() && UpgradeItemsRegistry.has(item) ? (WootUpgradeItem)((Object)((Object)UpgradeItemsRegistry.get(item).get())) : null;
        }, () -> {
            this.upgradeItem = null;
        });
        this.upgradeStack = this.upgradeItem == null ? ItemStack.EMPTY : component.upgradeStack().orElse(this.upgradeItem.getDefaultInstance());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        FactoryUpgradeData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        FactoryUpgradeData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }

    @NotNull
    public ModelData getModelData() {
        BlockState state = this.getBlockState();
        BlockRenderDispatcher renderer = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = renderer.getBlockModel(state);
        return model.getModelData((BlockAndTintGetter)this.level, this.getBlockPos(), this.getBlockState(), super.getModelData());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tryRequestModelDataUpdate() {
        if (this.level == null || this.level.getModelDataManager() == null) {
            return;
        }
        ModelData data = this.level.getModelDataManager().getAt(this.getBlockPos());
        if (data.has(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)) {
            if (this.upgradeItem == null && !((String)data.get(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)).isEmpty()) {
                this.requestModelDataUpdate();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            } else if (this.upgradeItem != null && !((String)data.get(FactoryUpgradeBakedModel.UPGRADE_PROPERTY)).equalsIgnoreCase(UpgradeItemsRegistry.getNameFromItem(this.upgradeItem))) {
                this.requestModelDataUpdate();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }
}

