/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.factory_upgrade;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.woot.blocks.factory_upgrade.FactoryUpgradeBlockEntity;
import wootrevived.woot.util.block.FactoryBlockBase;

public class FactoryUpgradeBlock
extends FactoryBlockBase {
    protected StateDefinition<Block, BlockState> upgradeStateDefinition;

    public FactoryUpgradeBlock(Supplier<BlockEntityType<?>> entity) {
        super(entity, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.STONE).strength(3.5f));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.upgradeStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.upgradeStateDefinition;
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    public static class State
    extends FactoryBlockBase.State {
        public State(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (!((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                return super.useItemOn(stack, level, player, hand, hit);
            }
            BlockEntity blockEntity = level.getBlockEntity(hit.getBlockPos());
            if (!level.isClientSide && blockEntity instanceof FactoryUpgradeBlockEntity) {
                Item item;
                FactoryUpgradeBlockEntity factoryUpgradeBlockEntity = (FactoryUpgradeBlockEntity)blockEntity;
                if (stack.isEmpty() && player.isShiftKeyDown()) {
                    factoryUpgradeBlockEntity.removeUpgrade(level, player, hand);
                    return ItemInteractionResult.SUCCESS;
                }
                if (!stack.isEmpty() && (item = stack.getItem()) instanceof WootUpgradeItem) {
                    WootUpgradeItem upgradeItem = (WootUpgradeItem)item;
                    factoryUpgradeBlockEntity.addUpgrade(level, player, hand, stack, upgradeItem);
                    return ItemInteractionResult.SUCCESS;
                }
                return factoryUpgradeBlockEntity.interactUpgrade(stack, level, player, hand, hit);
            }
            return super.useItemOn(stack, level, player, hand, hit);
        }

        @NotNull
        public InteractionResult useWithoutItem(@NotNull Level level, @NotNull Player player, @NotNull BlockHitResult hit) {
            return this.useItemOn(ItemStack.EMPTY, level, player, InteractionHand.MAIN_HAND, hit).result();
        }

        public void onRemove(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
            BlockEntity blockEntity;
            if (((Boolean)this.getValue((Property)BlockStateProperties.ENABLED)).booleanValue() && this.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FactoryUpgradeBlockEntity) {
                FactoryUpgradeBlockEntity factoryUpgradeBlockEntity = (FactoryUpgradeBlockEntity)blockEntity;
                factoryUpgradeBlockEntity.dropItem(level, pos);
            }
            super.onRemove(level, pos, newState, isMoving);
        }
    }
}

