/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.enchanted_liquifier;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.enchanted_liquifier.EnchantedLiquifierContainerMenu;
import wootrevived.woot.config.EnchantedLiquifierConfig;
import wootrevived.woot.data.EnchantedLiquifierData;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ComponentsRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;

public class EnchantedLiquifierBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private final List<EnumMap<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<EnumMap<MachineSide, MachineSideProperty>>(2);
    public static final int OUTPUT_FLUID_PROPERTY = 0;
    public static final int INGREDIENT_PROPERTY = 1;
    public final WootItemStackHandler inventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            EnchantedLiquifierBlockEntity.this.onContentsChanged(slot);
            EnchantedLiquifierBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() == Items.ENCHANTED_BOOK && EnchantmentHelper.hasAnyEnchantments((ItemStack)stack);
        }
    };
    public static int INPUT_SLOT = 0;

    public EnchantedLiquifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.ENCHANTED_LIQUIFIER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 2; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof EnchantedLiquifierBlockEntity) {
            EnchantedLiquifierBlockEntity enchantedLiquifierBlockEntity = (EnchantedLiquifierBlockEntity)blockEntity;
            enchantedLiquifierBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    @Override
    public void tick(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.tick(level, pos, state, blockEntity);
        if (level.isClientSide) {
            return;
        }
        this.tickItem(this.inventoryHandler, pos, side -> this.getProperties((Direction)side).getIngredientProperty());
        this.tickFluid(this.outputTankHandler, pos, (Integer)EnchantedLiquifierConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getOutputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventoryHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    public static IItemHandler getItemHandlerCapability(EnchantedLiquifierBlockEntity blockEntity, @Nullable Direction side) {
        if (side == null) {
            return blockEntity.inventoryHandler;
        }
        Properties properties = blockEntity.getProperties(side);
        return new WootItemHandlerWrapper().addHandler(blockEntity.inventoryHandler, properties::getIngredientProperty);
    }

    public static IFluidHandler getFluidHandlerCapability(EnchantedLiquifierBlockEntity blockEntity, @Nullable Direction side) {
        if (side == null) {
            return blockEntity.outputTankHandler;
        }
        Properties properties = blockEntity.getProperties(side);
        return new WootFluidHandlerWrapper().addHandler(blockEntity.outputTankHandler, properties::getOutputFluidProperty);
    }

    private EnchantedLiquifierData.Component getComponent() {
        return new EnchantedLiquifierData.Component(this.energyHandler.getEnergyStored(), this.getOutputTank().getFluid(), this.getAllMachineSidesProperties());
    }

    private void setComponent(EnchantedLiquifierData.Component component) {
        this.energyHandler.setEnergy(component.energy());
        this.getOutputTank().setFluid(component.outputFluid());
        this.setAllMachineSidesProperties(component.listMachineProperties());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        EnchantedLiquifierData.Component component = (EnchantedLiquifierData.Component)input.get(ComponentsRegistry.ENCHANTED_LIQUIFIER_DATA);
        if (component == null) {
            return;
        }
        this.setComponent(component);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(ComponentsRegistry.ENCHANTED_LIQUIFIER_DATA, (Object)this.getComponent());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("InputInventory", (Tag)this.inventoryHandler.serializeNBT(provider));
        EnchantedLiquifierData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("InputInventory")) {
            this.inventoryHandler.deserializeNBT(provider, tag.getCompound("InputInventory"));
        }
        EnchantedLiquifierData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.inventoryHandler.insertItem(INPUT_SLOT, ItemStack.EMPTY, false);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot_revived.enchanted_liquifier.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new EnchantedLiquifierContainerMenu(containerId, this.level, this.getBlockPos(), playerInventory, player);
    }

    @Override
    public EnumMap<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<EnumMap<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<EnumMap<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
    }

    @Override
    protected int getRecipeEnergy() {
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return 0;
        }
        return this.getEnchantEnergy(itemStack);
    }

    @Override
    protected void processFinished() {
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return;
        }
        this.inventoryHandler.extractItem(INPUT_SLOT, 1, false);
        int amount = this.getEnchantAmount(itemStack);
        this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), amount), IFluidHandler.FluidAction.EXECUTE);
        this.setChanged();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        int filled;
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        ItemStack itemStack = this.inventoryHandler.getStackInSlot(INPUT_SLOT);
        if (itemStack.isEmpty()) {
            return false;
        }
        if (!EnchantmentHelper.hasAnyEnchantments((ItemStack)itemStack)) {
            return false;
        }
        int amount = this.getEnchantAmount(itemStack);
        return amount == (filled = this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_ENCHANTED_FLUID.get(), amount), IFluidHandler.FluidAction.SIMULATE));
    }

    private int getEnchantAmount(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.isEmpty() && EnchantmentHelper.hasAnyEnchantments((ItemStack)itemStack)) {
            ItemEnchantments enchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            for (Holder enchantmentHolder : enchantments.keySet()) {
                amount += Mth.clamp((int)enchantments.getLevel(enchantmentHolder), (int)1, (int)((Integer)EnchantedLiquifierConfig.MAX_ENCHANT_LVL.get())) * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_FLUID.get();
            }
        }
        return amount;
    }

    private int getEnchantEnergy(ItemStack itemStack) {
        int amount = 0;
        if (!itemStack.isEmpty() && EnchantmentHelper.hasAnyEnchantments((ItemStack)itemStack)) {
            ItemEnchantments enchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            for (Holder enchantmentHolder : enchantments.keySet()) {
                amount += Mth.clamp((int)enchantments.getLevel(enchantmentHolder), (int)1, (int)((Integer)EnchantedLiquifierConfig.MAX_ENCHANT_LVL.get())) * (Integer)EnchantedLiquifierConfig.PER_ENCHANT_ENERGY.get();
            }
        }
        return amount;
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)EnchantedLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return 0;
    }

    @Override
    public boolean hasInputFluidCapability() {
        return false;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return null;
    }

    @Override
    public int getOutputTankCapacity() {
        return (Integer)EnchantedLiquifierConfig.OUTPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return true;
    }

    public record Properties(EnchantedLiquifierBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getIngredientProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }
    }
}

