/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.dye_liquifier;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.client.render.dye_liquifier.DyeLiquifierContainerMenu;
import wootrevived.woot.config.DyeLiquifierConfig;
import wootrevived.woot.data.DyeLiquifierData;
import wootrevived.woot.recipes.dye_liquifier.DyeLiquifierRecipe;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ComponentsRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.entity.WootMachineBlockEntity;
import wootrevived.woot.util.handlers.WootFluidHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemHandlerWrapper;
import wootrevived.woot.util.handlers.WootItemStackHandler;
import wootrevived.woot.util.recipes.WootRecipeInput;

public class DyeLiquifierBlockEntity
extends WootMachineBlockEntity
implements MenuProvider {
    private int red = 0;
    private int yellow = 0;
    private int blue = 0;
    private int white = 0;
    private final List<EnumMap<MachineSide, MachineSideProperty>> directionsProperties = new ArrayList<EnumMap<MachineSide, MachineSideProperty>>(5);
    public static final int OUTPUT_FLUID_PROPERTY = 0;
    public static final int RED_INGREDIENT_PROPERTY = 1;
    public static final int YELLOW_INGREDIENT_PROPERTY = 2;
    public static final int BLUE_INGREDIENT_PROPERTY = 3;
    public static final int WHITE_INGREDIENT_PROPERTY = 4;
    public final WootItemStackHandler redInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.RED);
        }
    };
    public final WootItemStackHandler yellowInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.YELLOW);
        }
    };
    public final WootItemStackHandler blueInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.BLUE);
        }
    };
    public final WootItemStackHandler whiteInventoryHandler = new WootItemStackHandler(false){

        protected void onContentsChanged(int slot) {
            DyeLiquifierBlockEntity.this.onContentsChanged(slot);
            DyeLiquifierBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return DyeLiquifierRecipe.Validator.isIngredientValid(stack, DyeLiquifierRecipe.Colors.WHITE);
        }
    };
    public static int INPUT_SLOT = 0;
    private final IItemHandler allSlotsHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.redInventoryHandler, this.yellowInventoryHandler, this.blueInventoryHandler, this.whiteInventoryHandler});
    private final Map<Integer, DyeLiquifierRecipe> recipes = new HashMap<Integer, DyeLiquifierRecipe>();

    public DyeLiquifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.DYE_LIQUIFIER_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < 5; ++i) {
            EnumMap properties = Maps.newEnumMap(MachineSide.class);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, MachineSideProperty.ENABLED);
            }
            this.directionsProperties.add(properties);
        }
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof DyeLiquifierBlockEntity) {
            DyeLiquifierBlockEntity dyeLiquifierBlockEntity = (DyeLiquifierBlockEntity)blockEntity;
            dyeLiquifierBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    @Override
    public void tick(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        super.tick(level, pos, state, blockEntity);
        if (level.isClientSide) {
            return;
        }
        this.generatePureFluid();
        this.tickItem(this.redInventoryHandler, pos, side -> this.getProperties((Direction)side).getRedIngredientProperty());
        this.tickItem(this.yellowInventoryHandler, pos, side -> this.getProperties((Direction)side).getYellowIngredientProperty());
        this.tickItem(this.blueInventoryHandler, pos, side -> this.getProperties((Direction)side).getBlueIngredientProperty());
        this.tickItem(this.whiteInventoryHandler, pos, side -> this.getProperties((Direction)side).getWhiteIngredientProperty());
        this.tickFluid(this.outputTankHandler, pos, (Integer)DyeLiquifierConfig.FLUID_TRANSFER.get(), side -> this.getProperties((Direction)side).getOutputFluidProperty());
    }

    @Override
    public IItemHandler getInventory() {
        return this.allSlotsHandler;
    }

    private Properties getProperties(Direction side) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Properties(this, MachineSide.getMachineSide(facing, side));
    }

    public static IItemHandler getItemHandlerCapability(DyeLiquifierBlockEntity blockEntity, @Nullable Direction side) {
        if (side == null) {
            return blockEntity.allSlotsHandler;
        }
        Properties properties = blockEntity.getProperties(side);
        return new WootItemHandlerWrapper().addHandler(blockEntity.redInventoryHandler, properties::getRedIngredientProperty).addHandler(blockEntity.blueInventoryHandler, properties::getBlueIngredientProperty).addHandler(blockEntity.yellowInventoryHandler, properties::getYellowIngredientProperty).addHandler(blockEntity.whiteInventoryHandler, properties::getWhiteIngredientProperty);
    }

    public static IFluidHandler getFluidHandlerCapability(DyeLiquifierBlockEntity blockEntity, @Nullable Direction side) {
        if (side == null) {
            return blockEntity.outputTankHandler;
        }
        Properties properties = blockEntity.getProperties(side);
        return new WootFluidHandlerWrapper().addHandler(blockEntity.outputTankHandler, properties::getOutputFluidProperty);
    }

    private DyeLiquifierData.Component getComponent() {
        return new DyeLiquifierData.Component(this.energyHandler.getEnergyStored(), this.getRed(), this.getYellow(), this.getBlue(), this.getWhite(), this.getOutputTank().getFluid(), this.getAllMachineSidesProperties());
    }

    private void setComponent(DyeLiquifierData.Component component) {
        this.energyHandler.setEnergy(component.energy());
        this.red = component.red();
        this.yellow = component.yellow();
        this.blue = component.blue();
        this.white = component.white();
        this.getOutputTank().setFluid(component.outputFluid());
        List<EnumMap<MachineSide, MachineSideProperty>> propertiesList = component.listMachineProperties();
        for (int i = 0; i < propertiesList.size(); ++i) {
            Map properties = this.directionsProperties.get(i);
            Map componentProperties = propertiesList.get(i);
            for (MachineSide side : MachineSide.values()) {
                properties.put(side, (MachineSideProperty)((Object)componentProperties.get((Object)side)));
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        DyeLiquifierData.Component component = (DyeLiquifierData.Component)input.get(ComponentsRegistry.DYE_LIQUIFIER_DATA);
        if (component == null) {
            return;
        }
        this.setComponent(component);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(ComponentsRegistry.DYE_LIQUIFIER_DATA, (Object)this.getComponent());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("RedInventory", (Tag)this.redInventoryHandler.serializeNBT(provider));
        tag.put("YellowInventory", (Tag)this.yellowInventoryHandler.serializeNBT(provider));
        tag.put("BlueInventory", (Tag)this.blueInventoryHandler.serializeNBT(provider));
        tag.put("WhiteInventory", (Tag)this.whiteInventoryHandler.serializeNBT(provider));
        DyeLiquifierData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("InputInventory")) {
            this.redInventoryHandler.deserializeNBT(provider, tag.getCompound("InputInventory"));
        }
        if (tag.contains("RedInventory")) {
            this.redInventoryHandler.deserializeNBT(provider, tag.getCompound("RedInventory"));
        }
        if (tag.contains("YellowInventory")) {
            this.yellowInventoryHandler.deserializeNBT(provider, tag.getCompound("YellowInventory"));
        }
        if (tag.contains("BlueInventory")) {
            this.blueInventoryHandler.deserializeNBT(provider, tag.getCompound("BlueInventory"));
        }
        if (tag.contains("WhiteInventory")) {
            this.whiteInventoryHandler.deserializeNBT(provider, tag.getCompound("WhiteInventory"));
        }
        DyeLiquifierData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    public void dropContents(Level level, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.redInventoryHandler.getStackInSlot(INPUT_SLOT).copy();
        if (!itemStack.isEmpty()) {
            drops.add(itemStack);
            this.redInventoryHandler.insertItem(INPUT_SLOT, ItemStack.EMPTY, false);
        }
        if (!(itemStack = this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT).copy()).isEmpty()) {
            drops.add(itemStack);
            this.yellowInventoryHandler.insertItem(INPUT_SLOT, ItemStack.EMPTY, false);
        }
        if (!(itemStack = this.blueInventoryHandler.getStackInSlot(INPUT_SLOT).copy()).isEmpty()) {
            drops.add(itemStack);
            this.blueInventoryHandler.insertItem(INPUT_SLOT, ItemStack.EMPTY, false);
        }
        if (!(itemStack = this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT).copy()).isEmpty()) {
            drops.add(itemStack);
            this.whiteInventoryHandler.insertItem(INPUT_SLOT, ItemStack.EMPTY, false);
        }
        super.dropContents(drops);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"gui.woot_revived.dye_liquifier.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new DyeLiquifierContainerMenu(containerId, this.level, this.getBlockPos(), playerInventory, player);
    }

    @Override
    public EnumMap<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
        return this.directionsProperties.get(index);
    }

    @Override
    public List<EnumMap<MachineSide, MachineSideProperty>> getAllMachineSidesProperties() {
        return this.directionsProperties;
    }

    @Override
    public void setAllMachineSidesProperties(List<EnumMap<MachineSide, MachineSideProperty>> directionsProperties) {
        for (int i = 0; i < directionsProperties.size(); ++i) {
            this.directionsProperties.set(i, directionsProperties.get(i));
        }
    }

    @Override
    protected boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    @Override
    protected int useEnergy() {
        return this.energyHandler.internalExtractEnergy(this.getEnergyProcessTransfer(), false);
    }

    @Override
    protected void clearRecipe() {
        this.recipes.clear();
    }

    @Override
    protected int getRecipeEnergy() {
        return this.recipes.values().stream().mapToInt(DyeLiquifierRecipe::getEnergy).sum();
    }

    private void generatePureFluid() {
        while (this.canCreateOutput() && this.canStoreOutput()) {
            this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get(), ((Integer)DyeLiquifierConfig.PURE_DYE_PRODUCE_AMOUNT.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
            this.red -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.yellow -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.blue -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.white -= ((Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get()).intValue();
            this.setChanged();
        }
    }

    @Override
    protected void processFinished() {
        ItemStack item;
        if (this.recipes.values().stream().allMatch(Objects::isNull)) {
            this.getRecipe();
        }
        if (this.recipes.values().stream().allMatch(Objects::isNull)) {
            this.processOff();
            return;
        }
        for (DyeLiquifierRecipe recipe : this.recipes.values()) {
            this.red += recipe.getRed();
            this.yellow += recipe.getYellow();
            this.blue += recipe.getBlue();
            this.white += recipe.getWhite();
        }
        this.red = Mth.clamp((int)this.red, (int)0, (int)((Integer)DyeLiquifierConfig.RED_TANK_CAPACITY.get()));
        this.yellow = Mth.clamp((int)this.yellow, (int)0, (int)((Integer)DyeLiquifierConfig.YELLOW_TANK_CAPACITY.get()));
        this.blue = Mth.clamp((int)this.blue, (int)0, (int)((Integer)DyeLiquifierConfig.BLUE_TANK_CAPACITY.get()));
        this.white = Mth.clamp((int)this.white, (int)0, (int)((Integer)DyeLiquifierConfig.WHITE_TANK_CAPACITY.get()));
        if (this.recipes.containsKey(0)) {
            item = this.redInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.getItem().hasCraftingRemainingItem(item)) {
                this.redInventoryHandler.setStackInSlot(INPUT_SLOT, item.getItem().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(0).ingredientCount(this.redInventoryHandler.getStackInSlot(INPUT_SLOT).getItem());
                this.redInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        if (this.recipes.containsKey(1)) {
            item = this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.getItem().hasCraftingRemainingItem(item)) {
                this.yellowInventoryHandler.setStackInSlot(INPUT_SLOT, item.getItem().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(1).ingredientCount(this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT).getItem());
                this.yellowInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        if (this.recipes.containsKey(2)) {
            item = this.blueInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.getItem().hasCraftingRemainingItem(item)) {
                this.blueInventoryHandler.setStackInSlot(INPUT_SLOT, item.getItem().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(2).ingredientCount(this.blueInventoryHandler.getStackInSlot(INPUT_SLOT).getItem());
                this.blueInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        if (this.recipes.containsKey(3)) {
            item = this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT);
            if (item.getItem().hasCraftingRemainingItem(item)) {
                this.whiteInventoryHandler.setStackInSlot(INPUT_SLOT, item.getItem().getCraftingRemainingItem(item));
            } else {
                int ingredientAmount = this.recipes.get(3).ingredientCount(this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT).getItem());
                this.whiteInventoryHandler.extractItem(INPUT_SLOT, ingredientAmount, false);
            }
        }
        this.setChanged();
    }

    @Override
    protected boolean canProcess(boolean checkEnergy) {
        if (checkEnergy && this.energyHandler.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.recipes.values().stream().allMatch(Objects::isNull)) {
            return false;
        }
        int red = 0;
        int yellow = 0;
        int blue = 0;
        int white = 0;
        for (DyeLiquifierRecipe recipe : this.recipes.values()) {
            red += recipe.getRed();
            yellow += recipe.getYellow();
            blue += recipe.getBlue();
            white += recipe.getWhite();
        }
        return this.canStoreInternal(red, yellow, blue, white);
    }

    private void getRecipe() {
        RecipeHolder recipeHolder = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (RecipeInput)new WootRecipeInput(Either.left((Object)this.redInventoryHandler.getStackInSlot(INPUT_SLOT))), this.level).orElse(null);
        if (recipeHolder != null) {
            this.recipes.put(0, (DyeLiquifierRecipe)recipeHolder.value());
        } else {
            this.recipes.remove(0);
        }
        recipeHolder = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (RecipeInput)new WootRecipeInput(Either.left((Object)this.yellowInventoryHandler.getStackInSlot(INPUT_SLOT))), this.level).orElse(null);
        if (recipeHolder != null) {
            this.recipes.put(1, (DyeLiquifierRecipe)recipeHolder.value());
        } else {
            this.recipes.remove(1);
        }
        recipeHolder = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (RecipeInput)new WootRecipeInput(Either.left((Object)this.blueInventoryHandler.getStackInSlot(INPUT_SLOT))), this.level).orElse(null);
        if (recipeHolder != null) {
            this.recipes.put(2, (DyeLiquifierRecipe)recipeHolder.value());
        } else {
            this.recipes.remove(2);
        }
        recipeHolder = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.DYE_LIQUIFIER_RECIPE_TYPE.get(), (RecipeInput)new WootRecipeInput(Either.left((Object)this.whiteInventoryHandler.getStackInSlot(INPUT_SLOT))), this.level).orElse(null);
        if (recipeHolder != null) {
            this.recipes.put(3, (DyeLiquifierRecipe)recipeHolder.value());
        } else {
            this.recipes.remove(3);
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getYellow() {
        return this.yellow;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getWhite() {
        return this.white;
    }

    private boolean canStoreInternal(int recipeRed, int recipeYellow, int recipeBlue, int recipeWhite) {
        boolean redHasSpace = recipeRed + this.red <= (Integer)DyeLiquifierConfig.RED_TANK_CAPACITY.get();
        boolean yellowHasSpace = recipeYellow + this.yellow <= (Integer)DyeLiquifierConfig.YELLOW_TANK_CAPACITY.get();
        boolean blueHasSpace = recipeBlue + this.blue <= (Integer)DyeLiquifierConfig.BLUE_TANK_CAPACITY.get();
        boolean whiteHasSpace = recipeWhite + this.white <= (Integer)DyeLiquifierConfig.WHITE_TANK_CAPACITY.get();
        return recipeRed > 0 && redHasSpace || recipeYellow > 0 && yellowHasSpace || recipeBlue > 0 && blueHasSpace || recipeWhite > 0 && whiteHasSpace;
    }

    private boolean canCreateOutput() {
        return this.red >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get() && this.yellow >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get() && this.blue >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get() && this.white >= (Integer)DyeLiquifierConfig.COLOR_PRODUCE_AMOUNT.get();
    }

    private boolean canStoreOutput() {
        return this.outputTankHandler.fill(new FluidStack((Fluid)FluidsRegistry.SOURCE_PURE_DYE_FLUID.get(), ((Integer)DyeLiquifierConfig.PURE_DYE_PRODUCE_AMOUNT.get()).intValue()), IFluidHandler.FluidAction.SIMULATE) == ((Integer)DyeLiquifierConfig.PURE_DYE_PRODUCE_AMOUNT.get()).intValue();
    }

    @Override
    public int getEnergyCapacity() {
        return (Integer)DyeLiquifierConfig.ENERGY_CAPACITY.get();
    }

    @Override
    public int getEnergyMaxTransfer() {
        return (Integer)DyeLiquifierConfig.ENERGY_MAX_TRANSFER.get();
    }

    @Override
    public int getEnergyProcessTransfer() {
        return (Integer)DyeLiquifierConfig.ENERGY_PROCESS_TRANSFER.get();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public int getInputTankCapacity() {
        return 0;
    }

    @Override
    public boolean hasInputFluidCapability() {
        return false;
    }

    @Override
    public Predicate<FluidStack> getInputFluidValidator() {
        return null;
    }

    @Override
    public int getOutputTankCapacity() {
        return (Integer)DyeLiquifierConfig.OUTPUT_TANK_CAPACITY.get();
    }

    @Override
    public boolean hasOutputFluidCapability() {
        return true;
    }

    public record Properties(DyeLiquifierBlockEntity entity, MachineSide machineSide) {
        public MachineSideProperty getRedIngredientProperty() {
            return this.entity.directionsProperties.get(1).get((Object)this.machineSide);
        }

        public MachineSideProperty getYellowIngredientProperty() {
            return this.entity.directionsProperties.get(2).get((Object)this.machineSide);
        }

        public MachineSideProperty getBlueIngredientProperty() {
            return this.entity.directionsProperties.get(3).get((Object)this.machineSide);
        }

        public MachineSideProperty getWhiteIngredientProperty() {
            return this.entity.directionsProperties.get(4).get((Object)this.machineSide);
        }

        public MachineSideProperty getOutputFluidProperty() {
            return this.entity.directionsProperties.get(0).get((Object)this.machineSide);
        }
    }
}

