/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.creative_tank;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.data.CreativeTankData;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ComponentsRegistry;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class CreativeTankBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    public WootFluidTankHandler inputTankHandler = this.createInputTank();

    public CreativeTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlocksRegistry.CREATIVE_TANK_BLOCK_ENTITY.get(), pos, state);
    }

    private WootFluidTankHandler createInputTank() {
        return new WootFluidTankHandler(Integer.MAX_VALUE, false){

            protected void onContentsChanged() {
                if (!this.getFluid().isEmpty()) {
                    this.getFluid().setAmount(Integer.MAX_VALUE);
                }
                CreativeTankBlockEntity.this.setChanged();
            }
        };
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof CreativeTankBlockEntity) {
            CreativeTankBlockEntity creativeTankBlockEntity = (CreativeTankBlockEntity)blockEntity;
            creativeTankBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        for (Direction facing : Direction.values()) {
            IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos().relative(facing), (Object)facing.getOpposite());
            if (handler == null) continue;
            handler.fill(new FluidStack(this.inputTankHandler.getFluid().getFluid(), handler.getTankCapacity(0)), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void setMaxCapacity() {
        this.inputTankHandler.getFluid().setAmount(Integer.MAX_VALUE);
        this.setChanged();
    }

    public void emptyIfDifferentFluidStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.inputTankHandler.getFluid(), (FluidStack)fluidStack)) {
            this.inputTankHandler.setFluid(FluidStack.EMPTY);
        }
    }

    public static IFluidHandler getFluidHandlerCapability(CreativeTankBlockEntity blockEntity, Direction side) {
        return blockEntity.inputTankHandler;
    }

    private CreativeTankData.Component getComponent() {
        return new CreativeTankData.Component(this.inputTankHandler.getFluid());
    }

    private void setComponent(CreativeTankData.Component component) {
        this.inputTankHandler.setFluid(component.tankFluid());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        CreativeTankData.Component component = (CreativeTankData.Component)input.get(ComponentsRegistry.CREATIVE_TANK_DATA);
        if (component == null) {
            return;
        }
        this.setComponent(component);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(ComponentsRegistry.CREATIVE_TANK_DATA, (Object)this.getComponent());
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CreativeTankData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        CreativeTankData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

