/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.creative_tank;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.creative_tank.CreativeTankBlockEntity;
import wootrevived.woot.registries.BlocksRegistry;

public class CreativeTankBlock
extends Block
implements EntityBlock {
    protected StateDefinition<Block, BlockState> creativeTankStateDefinition;

    public CreativeTankBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL));
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition(stateDefinitionBuilder);
        this.creativeTankStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, State::new);
        this.registerDefaultState((BlockState)this.getStateDefinition().any());
    }

    @NotNull
    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.creativeTankStateDefinition;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlocksRegistry.CREATIVE_TANK_BLOCK_ENTITY.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return blockEntityType == BlocksRegistry.CREATIVE_TANK_BLOCK_ENTITY.get() ? CreativeTankBlockEntity::ticker : null;
    }

    public static class State
    extends BlockState {
        public State(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> codec) {
            super(block, map, codec);
        }

        @NotNull
        public ItemInteractionResult useItemOn(@NotNull ItemStack heldItem, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
            if (level.isClientSide()) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(hit.getBlockPos());
            if (!(blockEntity instanceof CreativeTankBlockEntity)) {
                throw new IllegalStateException("BlockEntity is missing");
            }
            CreativeTankBlockEntity createTankBlockEntity = (CreativeTankBlockEntity)blockEntity;
            if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
                FluidStack stack = FluidUtil.getFluidHandler((ItemStack)heldItem).map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
                createTankBlockEntity.emptyIfDifferentFluidStack(stack);
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)hit.getBlockPos(), (Direction)hit.getDirection())) {
                    createTankBlockEntity.setMaxCapacity();
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.FAIL;
            }
            return ItemInteractionResult.SUCCESS;
        }
    }
}

