/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.blocks.cell;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.config.CellConfig;
import wootrevived.woot.data.CellData;
import wootrevived.woot.registries.BlocksRegistry;
import wootrevived.woot.registries.ComponentsRegistry;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.util.block.FactoryBlockBaseEntity;
import wootrevived.woot.util.handlers.WootFluidTankHandler;

public class CellBlockEntity
extends FactoryBlockBaseEntity {
    public final WootFluidTankHandler tankHandler = this.createTank();

    public CellBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
        this.tankHandler.setCapacity(this.getCapacity());
    }

    private WootFluidTankHandler createTank() {
        return new WootFluidTankHandler(1000, false, stack -> stack.is((Fluid)FluidsRegistry.SOURCE_VITALITY_FUEL_FLUID.get())){

            protected void onContentsChanged() {
                CellBlockEntity.this.setChanged();
            }
        };
    }

    private int getCapacity() {
        if (this.getType() == BlocksRegistry.COPPER_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.COPPER_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.IRON_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.IRON_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.GOLD_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.GOLD_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.DIAMOND_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.DIAMOND_CAPACITY.get();
        }
        if (this.getType() == BlocksRegistry.NETHERITE_CELL_BLOCK_ENTITY.get()) {
            return (Integer)CellConfig.NETHERITE_CAPACITY.get();
        }
        return 0;
    }

    public static IFluidHandler getFluidHandlerCapability(CellBlockEntity blockEntity, Direction side) {
        if (((Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return blockEntity.tankHandler;
        }
        return null;
    }

    private CellData.Component getComponent() {
        return new CellData.Component(this.tankHandler.getFluid());
    }

    private void setComponent(CellData.Component component) {
        this.tankHandler.setFluid(component.tankFluid());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        CellData.Component component = (CellData.Component)input.get(ComponentsRegistry.CELL_DATA);
        if (component == null) {
            return;
        }
        this.setComponent(component);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(ComponentsRegistry.CELL_DATA, (Object)this.getComponent());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CellData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getComponent()).result().ifPresent(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)t;
                tag.merge(compound);
            }
        });
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        CellData.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(this::setComponent);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }
}

