/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.api.internal;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.interfaces.WootUpgradeEnum;

@ApiStatus.Internal
public record WootUpgradeComponent(Class<? extends WootUpgradeEnum<?>> clazz, WootUpgradeEnum<?> variant) {
    public static final String ID = "upgrade_variant";
    private static final PrimitiveCodec<Class<? extends WootUpgradeEnum<?>>> CLASS_CODEC = new PrimitiveCodec<Class<? extends WootUpgradeEnum<?>>>(){

        public <T> DataResult<Class<? extends WootUpgradeEnum<?>>> read(DynamicOps<T> ops, T input) {
            DataResult className;
            DataResult dataResult = className = ops.getStringValue(input);
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success success = (DataResult.Success)dataResult2;
                    try {
                        Class<?> raw = Class.forName((String)success.value());
                        Class<WootUpgradeEnum> clazz = raw.asSubclass(WootUpgradeEnum.class);
                        return DataResult.success(clazz);
                    }
                    catch (Exception ex) {
                        return DataResult.error(ex::toString);
                    }
                }
                case 1: 
            }
            DataResult.Error error = (DataResult.Error)dataResult2;
            return DataResult.error(() -> ((DataResult.Error)error).message());
        }

        public <T> T write(DynamicOps<T> ops, Class<? extends WootUpgradeEnum<?>> value) {
            return (T)ops.createString(value.getName());
        }

        public String toString() {
            return "WootUpgradeEnumClass";
        }
    };
    private static final Codec<WootUpgradeComponent> CODEC = new Codec<WootUpgradeComponent>(){

        public <T> DataResult<T> encode(WootUpgradeComponent input, DynamicOps<T> ops, T prefix) {
            DataResult clazzEncoded;
            DataResult dataResult = clazzEncoded = CLASS_CODEC.encodeStart(ops, input.clazz());
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult variantEncoded;
                    DataResult.Success clazz = (DataResult.Success)dataResult2;
                    WootUpgradeEnum<?> v = input.variant();
                    Codec<?> variantCodec = v.codec();
                    DataResult dataResult3 = variantEncoded = variantCodec.encodeStart(ops, v);
                    Objects.requireNonNull(dataResult3);
                    DataResult dataResult4 = dataResult3;
                    int n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult4, n2)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            DataResult.Success variant = (DataResult.Success)dataResult4;
                            RecordBuilder builder = ops.mapBuilder();
                            builder.add(ops.createString("clazz"), clazz.value());
                            builder.add(ops.createString("variant"), variant.value());
                            return builder.build(prefix);
                        }
                        case 1: 
                    }
                    DataResult.Error error = (DataResult.Error)dataResult4;
                    return DataResult.error(() -> ((DataResult.Error)error).message());
                }
                case 1: 
            }
            DataResult.Error error = (DataResult.Error)dataResult2;
            return DataResult.error(() -> ((DataResult.Error)error).message());
        }

        public <T> DataResult<Pair<WootUpgradeComponent, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).flatMap(map -> {
                DataResult clazzResult;
                Object clazzNode = map.get(ops.createString("clazz"));
                Object variantNode = map.get(ops.createString("variant"));
                if (clazzNode == null) {
                    return DataResult.error(() -> "Missing field: clazz");
                }
                if (variantNode == null) {
                    return DataResult.error(() -> "Missing field: variant");
                }
                DataResult dataResult = clazzResult = CLASS_CODEC.read(ops, clazzNode);
                Objects.requireNonNull(dataResult);
                DataResult selector0$temp = dataResult;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)selector0$temp, index$1)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        DataResult variantResult;
                        Codec<? extends WootUpgradeEnum<?>> rawVariantCodec;
                        DataResult.Success clazzSuccess = (DataResult.Success)selector0$temp;
                        Class clazz = (Class)clazzSuccess.value();
                        try {
                            rawVariantCodec = WootUpgradeComponent.variantCodecFor(clazz);
                        }
                        catch (Exception ex) {
                            return DataResult.error(ex::toString);
                        }
                        Codec<? extends WootUpgradeEnum<?>> variantCodec = rawVariantCodec;
                        DataResult dataResult2 = variantResult = variantCodec.decode(ops, variantNode);
                        Objects.requireNonNull(dataResult2);
                        DataResult selector2$temp = dataResult2;
                        int index$3 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)selector2$temp, index$3)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                DataResult.Success variantSuccess = (DataResult.Success)selector2$temp;
                                WootUpgradeEnum variant = (WootUpgradeEnum)((Pair)variantSuccess.value()).getFirst();
                                WootUpgradeComponent component = new WootUpgradeComponent(clazz, variant);
                                return DataResult.success((Object)Pair.of((Object)component, (Object)input));
                            }
                            case 1: 
                        }
                        DataResult.Error error = (DataResult.Error)selector2$temp;
                        return DataResult.error(() -> ((DataResult.Error)error).message());
                    }
                    case 1: 
                }
                DataResult.Error error = (DataResult.Error)selector0$temp;
                return DataResult.error(() -> ((DataResult.Error)error).message());
            });
        }
    };
    private static final StreamCodec<RegistryFriendlyByteBuf, WootUpgradeComponent> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, WootUpgradeComponent>(){

        public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull WootUpgradeComponent comp) {
            DataResult variantEncoded;
            buf.writeUtf(comp.clazz().getName());
            Codec<?> codec = comp.variant().codec();
            DataResult dataResult = variantEncoded = codec.encodeStart((DynamicOps)NbtOps.INSTANCE, comp.variant());
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success variant = (DataResult.Success)dataResult2;
                    ByteBufCodecs.TAG.encode((Object)buf, (Object)((Tag)variant.value()));
                    return;
                }
                case 1: 
            }
            DataResult.Error error = (DataResult.Error)dataResult2;
            throw new IllegalStateException("Failed to encode upgrade variant: " + error.message());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public WootUpgradeComponent decode(@NotNull RegistryFriendlyByteBuf buf) {
            DataResult variantResult;
            Codec<? extends WootUpgradeEnum<?>> rawCodec;
            Class<WootUpgradeEnum> clazz;
            String className = buf.readUtf();
            try {
                Class<?> raw = Class.forName(className);
                clazz = raw.asSubclass(WootUpgradeEnum.class);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Invalid upgrade enum class: " + className, ex);
            }
            Codec<? extends WootUpgradeEnum<?>> variantCodec = rawCodec = WootUpgradeComponent.variantCodecFor(clazz);
            Tag dynamic = (Tag)ByteBufCodecs.TAG.decode((Object)buf);
            DataResult dataResult = variantResult = variantCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)dynamic);
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success variant = (DataResult.Success)dataResult2;
                    return new WootUpgradeComponent(clazz, (WootUpgradeEnum)variant.value());
                }
                case 1: 
            }
            DataResult.Error error = (DataResult.Error)dataResult2;
            throw new IllegalStateException("Failed to decode upgrade variant: " + error.message());
        }
    };
    private static final DataComponentType<WootUpgradeComponent> TYPE = DataComponentType.builder().persistent(CODEC).networkSynchronized(STREAM_CODEC).build();

    public WootUpgradeComponent {
        if (clazz == null || variant == null) {
            throw new IllegalArgumentException("clazz and variant must not be null");
        }
        Class actual = ((Enum)((Object)variant)).getDeclaringClass();
        if (!clazz.equals(actual)) {
            throw new IllegalArgumentException("clazz (" + clazz.getName() + ") does not match variant declaring class (" + actual.getName() + ")");
        }
    }

    public static <T extends Enum<T>> WootUpgradeComponent of(T variant) {
        return new WootUpgradeComponent(variant.getDeclaringClass(), (WootUpgradeEnum)((Object)variant));
    }

    public static DataComponentType<WootUpgradeComponent> type() {
        return TYPE;
    }

    private static Codec<? extends WootUpgradeEnum<?>> variantCodecFor(Class<? extends WootUpgradeEnum<?>> clazz) {
        if (!clazz.isEnum()) {
            throw new IllegalStateException("Not an enum: " + String.valueOf(clazz));
        }
        WootUpgradeEnum<?>[] constants = clazz.getEnumConstants();
        if (constants == null || constants.length == 0) {
            throw new IllegalStateException("Empty enum: " + String.valueOf(clazz));
        }
        WootUpgradeEnum<?> any = constants[0];
        return any.codec();
    }

    @Override
    public int hashCode() {
        int result = this.clazz.getName().hashCode();
        result = 31 * result + this.variant.getSerializedName().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WootUpgradeComponent)) {
            return false;
        }
        WootUpgradeComponent c = (WootUpgradeComponent)obj;
        return this.clazz.getName().equals(c.clazz.getName()) && this.variant.getSerializedName().equals(c.variant.getSerializedName());
    }
}

