/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.api;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.api.internal.WootUpgradeComponent;

public abstract class WootUpgradeItem<T extends Enum<T>>
extends Item {
    protected final WootUpgradeComponent defaultVariant;

    public WootUpgradeItem(@NotNull Item.Properties properties, @NotNull T defaultVariant) {
        super(properties.component(WootUpgradeComponent.type(), (Object)WootUpgradeComponent.of(defaultVariant)));
        this.defaultVariant = WootUpgradeComponent.of(defaultVariant);
    }

    public void initDataComponents(@NotNull MutableDataComponentHolder dataComponentHolder, @NotNull Level level, @NotNull BlockPos pos) {
    }

    public void deinitDataComponents(@NotNull MutableDataComponentHolder dataComponentHolder, @NotNull Level level, @NotNull BlockPos pos) {
    }

    public void applyGenerationProperties(@NotNull WootGenerationProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
    }

    public void applySpawnProperties(@NotNull WootSpawnProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
    }

    public void modifyDrops(@NotNull WootDropsProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
    }

    @NotNull
    public ItemInteractionResult interact(@NotNull MutableDataComponentHolder dataComponentHolder, @NotNull ItemStack stack, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public final T getVariant(@Nullable MutableDataComponentHolder dataComponentHolder) {
        if (dataComponentHolder == null) {
            return (T)((Enum)((Object)this.defaultVariant.variant()));
        }
        try {
            return (T)((Enum)((Object)((WootUpgradeComponent)dataComponentHolder.getOrDefault(WootUpgradeComponent.type(), (Object)this.defaultVariant)).variant()));
        }
        catch (Exception ex) {
            dataComponentHolder.remove(WootUpgradeComponent.type());
            return (T)((Enum)((Object)this.defaultVariant.variant()));
        }
    }

    public final void setVariant(@NotNull MutableDataComponentHolder dataComponentHolder, @Nullable T variant) {
        if (variant != null) {
            dataComponentHolder.set(WootUpgradeComponent.type(), (Object)WootUpgradeComponent.of(variant));
        } else {
            dataComponentHolder.remove(WootUpgradeComponent.type());
        }
    }

    public ResourceLocation getTextureLocation(@NotNull T variant) {
        return BuiltInRegistries.ITEM.getKey((Object)this).withPrefix("textures/item/").withSuffix(".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyItemTexture(@NotNull NativeImage upgradeItem, @NotNull T variant) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyUpgradeTexture(@NotNull NativeImage upgradeSide, @NotNull NativeImage upgradeItem, @NotNull T variant) {
        for (int y = 2; y < 14; ++y) {
            for (int x = 2; x < 14; ++x) {
                int color = upgradeItem.getPixelRGBA(x, y);
                int alpha = color >> 24;
                if (alpha == 0) continue;
                upgradeSide.setPixelRGBA(x, y, color);
            }
        }
    }
}

