/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.canitzp.feederhelmet.FeederHelmet;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record RecipeModuleAddition(Item helmet, String module, ItemStack outputStack) implements SmithingRecipe
{
    public RecipeModuleAddition(ResourceLocation loc, String module, ItemStack outputStack) {
        this((Item)BuiltInRegistries.ITEM.get(loc), module, outputStack);
    }

    public boolean isTemplateIngredient(ItemStack stack) {
        return stack.isEmpty();
    }

    public boolean isBaseIngredient(ItemStack stack) {
        return stack.is(this.helmet) && !FeederHelmet.hasModule(stack, this.module);
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        return stack.is((Item)FeederHelmet.FEEDER_HELMET_MODULE_ITEM.get());
    }

    public boolean matches(SmithingRecipeInput container, Level level) {
        return this.isTemplateIngredient(container.getItem(0)) && this.isBaseIngredient(container.getItem(1)) && this.isAdditionIngredient(container.getItem(2));
    }

    public ItemStack assemble(SmithingRecipeInput container, HolderLookup.Provider access) {
        ItemStack assembled = this.getResultItem(access).copy();
        assembled.applyComponents(container.getItem(1).getComponents());
        FeederHelmet.addModule(assembled, this.module);
        return assembled;
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.outputStack;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeModuleAddition> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<RecipeModuleAddition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("helmet").forGetter(recipe -> BuiltInRegistries.ITEM.getKey((Object)recipe.helmet)), (App)Codec.STRING.fieldOf("module").forGetter(RecipeModuleAddition::module), (App)ItemStack.CODEC.fieldOf("result").forGetter(RecipeModuleAddition::outputStack)).apply((Applicative)instance, RecipeModuleAddition::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeModuleAddition> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static RecipeModuleAddition fromNetwork(RegistryFriendlyByteBuf buffer) {
            Item helmet = (Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation());
            String module = buffer.readUtf();
            ItemStack outputStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new RecipeModuleAddition(helmet, module, outputStack);
        }

        @NotNull
        public MapCodec<RecipeModuleAddition> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeModuleAddition> streamCodec() {
            return STREAM_CODEC;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, RecipeModuleAddition recipe) {
            buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)recipe.helmet));
            buffer.writeUtf(recipe.module);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputStack);
        }
    }
}

