/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet.recipe;

import de.canitzp.feederhelmet.FeederHelmet;
import de.canitzp.feederhelmet.module.IHelmetModule;
import de.canitzp.feederhelmet.recipe.RecipeModuleAddition;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FeederRecipeManager {
    public static void injectRecipes(Level level) {
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        FeederHelmet.LOGGER.info("Feeder Helmet recipe injecting...");
        RecipeManager recipeManager = level.getRecipeManager();
        ArrayList<RecipeHolder> allNewRecipes = new ArrayList<RecipeHolder>();
        for (IHelmetModule module : FeederHelmet.MODULES) {
            for (Item helmet : BuiltInRegistries.ITEM) {
                if (!module.isModuleApplicableTo(helmet.getDefaultInstance())) continue;
                ResourceLocation helmetKey = BuiltInRegistries.ITEM.getKey((Object)helmet);
                ResourceLocation creationCraftingId = ResourceLocation.fromNamespaceAndPath((String)"feederhelmet", (String)(module.getTagName() + "_creation_" + helmetKey.getNamespace() + "_" + helmetKey.getPath()));
                ResourceLocation removalCraftingId = ResourceLocation.fromNamespaceAndPath((String)"feederhelmet", (String)(module.getTagName() + "_removal_" + helmetKey.getNamespace() + "_" + helmetKey.getPath()));
                Recipe<?> creationRecipe = FeederRecipeManager.creationRecipe(module, helmet);
                Recipe<?> removalRecipe = FeederRecipeManager.removalRecipe(module, helmet);
                if (recipeManager.getRecipeIds().noneMatch(resourceLocation -> resourceLocation.equals((Object)creationCraftingId))) {
                    allNewRecipes.add(new RecipeHolder(creationCraftingId, creationRecipe));
                    FeederHelmet.LOGGER.info(String.format("Feeder Helmet created %s recipe for %s with id '%s'", module.getTagName(), helmetKey, creationCraftingId));
                }
                if (!recipeManager.getRecipeIds().noneMatch(resourceLocation -> resourceLocation.equals((Object)removalCraftingId))) continue;
                allNewRecipes.add(new RecipeHolder(removalCraftingId, removalRecipe));
                FeederHelmet.LOGGER.info(String.format("Feeder Helmet created %s recipe for %s with id '%s'", module.getTagName(), helmetKey, removalCraftingId));
            }
        }
        try {
            allNewRecipes.addAll(recipeManager.getRecipes());
            recipeManager.replaceRecipes(allNewRecipes);
        }
        catch (IllegalStateException e) {
            FeederHelmet.LOGGER.error("Feeder Helmet: Illegal recipe replacement caught! Report this to author immediately!", (Throwable)e);
        }
    }

    public static Recipe<?> creationRecipe(IHelmetModule module, Item helmet) {
        ItemStack outputStack = helmet.getDefaultInstance();
        FeederHelmet.addModule(outputStack, module.getTagName());
        return new RecipeModuleAddition(helmet, module.getTagName(), outputStack);
    }

    public static Recipe<?> removalRecipe(final IHelmetModule module, Item helmet) {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{helmet}));
        ItemStack outputStack = helmet.getDefaultInstance();
        return new ShapelessRecipe("", CraftingBookCategory.EQUIPMENT, outputStack, ingredients){

            public ItemStack assemble(CraftingInput container, HolderLookup.Provider access) {
                ItemStack assembled = super.assemble(container, access);
                ItemStack inputStack = ItemStack.EMPTY;
                for (int slotId = 0; slotId < container.size(); ++slotId) {
                    if (container.getItem(slotId).isEmpty()) continue;
                    inputStack = container.getItem(slotId).copy();
                    break;
                }
                if (!inputStack.isEmpty()) {
                    if (inputStack.has(FeederHelmet.DC_MODULES)) {
                        FeederHelmet.removeModule(inputStack, module.getTagName());
                    }
                    assembled.applyComponents(inputStack.getComponents());
                }
                return assembled;
            }

            public boolean matches(CraftingInput container, Level level) {
                boolean matches = super.matches(container, level);
                if (!matches) {
                    return false;
                }
                ItemStack inputStack = ItemStack.EMPTY;
                for (int slotId = 0; slotId < container.size(); ++slotId) {
                    if (container.getItem(slotId).isEmpty()) continue;
                    inputStack = container.getItem(slotId);
                    break;
                }
                if (inputStack.isEmpty()) {
                    return false;
                }
                return FeederHelmet.hasModule(inputStack, module.getTagName());
            }

            public NonNullList<ItemStack> getRemainingItems(CraftingInput container) {
                NonNullList remainingItems = super.getRemainingItems((RecipeInput)container);
                remainingItems.set(0, (Object)FeederHelmet.FEEDER_HELMET_MODULE_ITEM.get().getDefaultInstance());
                return remainingItems;
            }
        };
    }
}

