/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet.module;

import de.canitzp.feederhelmet.EnergyHandler;
import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.FeederHelmet;
import de.canitzp.feederhelmet.ItemStackUtil;
import de.canitzp.feederhelmet.module.IHelmetModule;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;

public class FeederModule
implements IHelmetModule {
    @Override
    public Item getCorrespondingModuleItem() {
        return FeederHelmet.FEEDER_HELMET_MODULE_ITEM.get();
    }

    @Override
    public String getTagName() {
        return "feeder_module";
    }

    @Override
    public boolean isModuleApplicableTo(ItemStack stack) {
        return FeederHelmet.isItemHelmet(stack);
    }

    @Override
    public void renderTooltip(@Nonnull ItemStack stack, @Nullable Player entityPlayer, List<Component> list, TooltipFlag flags) {
        list.add((Component)Component.translatable((String)"item.feederhelmet:feeder_helmet_module_installed.text").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
    }

    @Override
    public void updatePlayer(Player player, ItemStack helmetStack) {
        if (!player.getAbilities().invulnerable && player.canEat(false) && FeederHelmet.canDamageBeReducedOrEnergyConsumed(helmetStack)) {
            for (ItemStack inventoryStack : player.getInventory().items) {
                if (!FeederModule.canHelmetEatStack(player.level(), inventoryStack) || !FeederModule.canPlayerEat(player, inventoryStack) || !player.canEat(false)) continue;
                AtomicBoolean hasEnergy = new AtomicBoolean(false);
                AtomicBoolean canEat = new AtomicBoolean(false);
                IEnergyStorage capability = (IEnergyStorage)helmetStack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (capability != null) {
                    hasEnergy.set(true);
                    EnergyHandler energyHandler = EnergyHandler.get(helmetStack);
                    if (energyHandler != null && energyHandler.canBeUsed((Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get())) {
                        energyHandler.use();
                        canEat.set(true);
                    }
                }
                if (!hasEnergy.get()) {
                    if (helmetStack.isDamageableItem()) {
                        helmetStack.setDamageValue(helmetStack.getDamageValue() + (Integer)FeederConfig.GENERAL.DURABILITY.get());
                        if (helmetStack.getMaxDamage() - helmetStack.getDamageValue() <= 0) {
                            helmetStack.setCount(0);
                        }
                    }
                    canEat.set(true);
                }
                if (!canEat.get()) continue;
                EventHooks.onItemUseStart((LivingEntity)player, (ItemStack)inventoryStack, (int)0);
                ItemStack result = inventoryStack.getItem().finishUsingItem(inventoryStack, player.getCommandSenderWorld(), (LivingEntity)player);
                EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)inventoryStack, (int)0, (ItemStack)result);
                break;
            }
        }
    }

    private static boolean canHelmetEatStack(Level level, @Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (ItemStackUtil.isFoodBlacklisted(stack)) {
            return false;
        }
        if (ItemStackUtil.isFoodWhitelisted(stack)) {
            return true;
        }
        if (((Boolean)FeederConfig.GENERAL.BLACKLIST_SMELTABLES.get()).booleanValue() && ItemStackUtil.isSmeltable(level, stack)) {
            return false;
        }
        return ItemStackUtil.isEatable(stack);
    }

    private static boolean canPlayerEat(Player player, ItemStack stack) {
        if (!stack.isEmpty() && ItemStackUtil.isEatable(stack)) {
            if (((Boolean)FeederConfig.GENERAL.WAIT_UNITL_FILL_ALL_HUNGER.get()).booleanValue()) {
                return player.getFoodData().getFoodLevel() + stack.getItem().getFoodProperties(stack, (LivingEntity)player).nutrition() <= 20 || (Boolean)FeederConfig.GENERAL.IGNORE_WAITING_WHEN_LOW_HEART.get() != false && player.getHealth() <= 10.0f;
            }
            return true;
        }
        return true;
    }
}

