/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.FeederConfig;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;

public class ItemStackUtil {
    public static String getItemStackResourceLocationString(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
    }

    public static boolean isFoodBlacklisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.FOOD_BLACKLIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }

    public static boolean isFoodWhitelisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.FOOD_WHITELIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }

    public static boolean isSmeltable(Level level, ItemStack stack) {
        return level.getRecipeManager().getAllRecipesFor(RecipeType.SMELTING).stream().anyMatch(furnaceRecipe -> ((SmeltingRecipe)furnaceRecipe.value()).getIngredients().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    public static boolean isEatable(ItemStack stack) {
        return stack.has(DataComponents.FOOD);
    }

    public static boolean isHelmetBlacklisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.HELMET_BLACKLIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }

    public static boolean isHelmetWhitelisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.HELMET_WHITELIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }
}

