/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.FeederTab;
import de.canitzp.feederhelmet.ItemStackUtil;
import de.canitzp.feederhelmet.item.ItemFeederModule;
import de.canitzp.feederhelmet.item.ItemPhotosynthesisModule;
import de.canitzp.feederhelmet.module.FeederModule;
import de.canitzp.feederhelmet.module.IHelmetModule;
import de.canitzp.feederhelmet.module.PhotosynthesisModule;
import de.canitzp.feederhelmet.recipe.FeederRecipeManager;
import de.canitzp.feederhelmet.recipe.RecipeModuleAddition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber
@Mod(value="feederhelmet")
public class FeederHelmet {
    public static final String MODID = "feederhelmet";
    public static final Logger LOGGER = LogManager.getLogger((String)"feederhelmet");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"feederhelmet");
    public static final Holder<CreativeModeTab> TAB = TABS.register("tab", FeederTab::create);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"feederhelmet");
    public static final Supplier<RecipeSerializer<RecipeModuleAddition>> MODULE_ADDITION_SERIALIZER = RECIPE_SERIALIZER.register("module_addition", () -> RecipeModuleAddition.Serializer.INSTANCE);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"feederhelmet");
    public static final Supplier<ItemFeederModule> FEEDER_HELMET_MODULE_ITEM = ITEMS.register("feeder_helmet_module", ItemFeederModule::new);
    public static final Supplier<ItemPhotosynthesisModule> PHOTOSYNTHESIS_MODULE_ITEM = ITEMS.register("photosynthesis_helmet_module", ItemPhotosynthesisModule::new);
    public static final DeferredRegister.DataComponents DATA_COMPONENT_TYPE = DeferredRegister.createDataComponents((String)"feederhelmet");
    public static final Supplier<DataComponentType<List<String>>> DC_MODULES = DATA_COMPONENT_TYPE.registerComponentType("modules", listBuilder -> listBuilder.persistent(Codec.STRING.listOf()).networkSynchronized(ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list())).cacheEncoding());
    public static final List<IHelmetModule> MODULES = new ArrayList<IHelmetModule>();

    public FeederHelmet(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Feeder Helmet loading...");
        MODULES.add(new FeederModule());
        MODULES.add(new PhotosynthesisModule());
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FeederConfig.spec);
        TABS.register(modEventBus);
        RECIPE_SERIALIZER.register(modEventBus);
        ITEMS.register(modEventBus);
        DATA_COMPONENT_TYPE.register(modEventBus);
        LOGGER.info("Feeder Helmet loaded.");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderTooltips(ItemTooltipEvent event) {
        if (!event.getItemStack().isEmpty()) {
            for (IHelmetModule module : MODULES) {
                if (!FeederHelmet.hasModule(event.getItemStack(), module.getTagName())) continue;
                module.renderTooltip(event.getItemStack(), event.getEntity(), event.getToolTip(), event.getFlags());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor.isClientSide()) {
            return;
        }
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            FeederRecipeManager.injectRecipes(level);
        }
    }

    @SubscribeEvent
    public static void updatePlayer(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide() && event.getEntity().getCommandSenderWorld().getGameTime() % (long)((Integer)FeederConfig.GENERAL.WAIT_TICKS.get()).intValue() == 0L) {
            ItemStack helmetStack = (ItemStack)event.getEntity().getInventory().armor.get(EquipmentSlot.HEAD.getIndex());
            for (IHelmetModule module : MODULES) {
                if (!FeederHelmet.hasModule(helmetStack, module.getTagName())) continue;
                module.updatePlayer(event.getEntity(), helmetStack);
            }
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        NonNullList armorInventory = player.getInventory().armor;
        NonNullList mainInventory = player.getInventory().items;
        NonNullList offHandInventory = player.getInventory().offhand;
        NonNullList mergedInventory = NonNullList.create();
        mergedInventory.addAll((Collection)armorInventory);
        mergedInventory.addAll((Collection)mainInventory);
        mergedInventory.addAll((Collection)offHandInventory);
        for (ItemStack stack : mergedInventory) {
            if (!stack.has(DataComponents.CUSTOM_DATA)) continue;
            CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            ArrayList<String> foundModules = new ArrayList<String>();
            if (tag.contains("AutoFeederHelmet", 1)) {
                foundModules.add("feeder_module");
                tag.remove("AutoFeederHelmet");
                stack.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag)).build());
            }
            if (tag.contains("modules", 9)) {
                tag.getList("modules", 8).forEach(tag1 -> foundModules.add(tag1.getAsString()));
                tag.remove("modules");
                stack.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag)).build());
            }
            if (foundModules.isEmpty()) continue;
            foundModules.forEach(s -> FeederHelmet.addModule(stack, s));
        }
    }

    @SubscribeEvent
    public static void anvilRepair(AnvilRepairEvent event) {
        ItemStack toRepair = event.getLeft();
        ItemStack result = event.getOutput();
        if (toRepair.has(DC_MODULES)) {
            result.applyComponents(DataComponentPatch.builder().set(DC_MODULES.get(), (Object)((List)toRepair.get(DC_MODULES))).build());
        }
    }

    public static boolean isItemHelmet(ItemStack stack) {
        return stack.getItem() instanceof ArmorItem && ((ArmorItem)stack.getItem()).getType().getSlot() == EquipmentSlot.HEAD && !ItemStackUtil.isHelmetBlacklisted(stack) || ItemStackUtil.isHelmetWhitelisted(stack);
    }

    public static boolean canDamageBeReducedOrEnergyConsumed(@Nonnull ItemStack stack) {
        AtomicBoolean canWork = new AtomicBoolean(false);
        IEnergyStorage energyCapability = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyCapability != null) {
            canWork.set(true);
        }
        if (!canWork.get()) {
            if (stack.isDamageableItem()) {
                int newDmg = stack.getDamageValue() + (Integer)FeederConfig.GENERAL.DURABILITY.get();
                if (((Boolean)FeederConfig.GENERAL.CAN_BREAK.get()).booleanValue()) {
                    canWork.set(newDmg <= stack.getMaxDamage());
                } else {
                    canWork.set(newDmg < stack.getMaxDamage());
                }
            } else {
                canWork.set(true);
            }
        }
        return canWork.get();
    }

    public static boolean hasModule(ItemStack stack, String module) {
        return stack.has(DC_MODULES) && ((List)stack.get(DC_MODULES.get())).contains(module);
    }

    public static void addModule(ItemStack stack, String module) {
        if (stack.has(DC_MODULES)) {
            if (!((List)stack.get(DC_MODULES)).contains(module)) {
                ArrayList<String> modules = new ArrayList<String>((Collection)stack.get(DC_MODULES));
                modules.add(module);
                stack.set(DC_MODULES, modules);
            }
        } else {
            stack.set(DC_MODULES, (Object)Lists.newArrayList((Object[])new String[]{module}));
        }
    }

    public static void removeModule(ItemStack stack, String module) {
        if (stack.has(DC_MODULES)) {
            ArrayList modules = new ArrayList((Collection)stack.get(DC_MODULES));
            modules.remove(module);
            stack.set(DC_MODULES, modules);
        }
    }
}

