/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class EnergyHandler {
    private ItemStack stack;
    private CompoundTag tag;

    public static EnergyHandler get(@Nonnull ItemStack stack) {
        CompoundTag mekData;
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return null;
        }
        CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (tag.contains("Energy", 3)) {
            return new Simple(stack, tag, "Energy");
        }
        if (tag.contains("energy", 3)) {
            return new Simple(stack, tag, "energy");
        }
        if (tag.contains("enderio.darksteel.upgrade.energyUpgrade", 10)) {
            return new EnderIOEnergyUpgrade(stack, tag);
        }
        if (tag.contains("mekData", 10) && (mekData = tag.getCompound("mekData")).contains("EnergyContainers", 9)) {
            return new MekanismMekaSuit(stack, tag, mekData.getList("EnergyContainers", 10));
        }
        if (tag.contains("charge", 6)) {
            return new IC2(stack, tag);
        }
        return null;
    }

    public EnergyHandler(ItemStack stack, CompoundTag tag) {
        this.stack = stack;
        this.tag = tag;
    }

    public abstract boolean canBeUsed(int var1);

    public abstract void use();

    public static class Simple
    extends EnergyHandler {
        private String tagName;
        private int energy;
        private int energyAfterUsage;

        public Simple(ItemStack stack, CompoundTag tag, String tagName) {
            super(stack, tag);
            this.tagName = tagName;
            this.energy = tag.getInt(this.tagName);
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            this.energyAfterUsage = this.energy - energyToExtract;
            return this.energyAfterUsage >= 0;
        }

        @Override
        public void use() {
            this.tag.putInt(this.tagName, this.energyAfterUsage);
            this.stack.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.tag)).build());
        }
    }

    public static class EnderIOEnergyUpgrade
    extends EnergyHandler {
        private int energy;
        private int energyAfterUsage;

        public EnderIOEnergyUpgrade(ItemStack stack, CompoundTag tag) {
            super(stack, tag);
            this.energy = tag.getCompound("enderio.darksteel.upgrade.energyUpgrade").getInt("energy");
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            this.energyAfterUsage = this.energy - energyToExtract;
            return this.energyAfterUsage >= 0;
        }

        @Override
        public void use() {
            this.tag.getCompound("enderio.darksteel.upgrade.energyUpgrade").putInt("energy", this.energyAfterUsage);
            this.stack.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.tag)).build());
        }
    }

    public static class MekanismMekaSuit
    extends EnergyHandler {
        private ListTag tagEnergyContainers;
        private int energy;
        private int energyToExtract;

        public MekanismMekaSuit(ItemStack stack, CompoundTag tag, ListTag tagEnergyContainers) {
            super(stack, tag);
            this.tagEnergyContainers = tagEnergyContainers;
            for (Tag energyContainer : tagEnergyContainers) {
                CompoundTag compound;
                String storedAsString;
                if (!(energyContainer instanceof CompoundTag) || !NumberUtils.isParsable((String)(storedAsString = (compound = (CompoundTag)energyContainer).getString("stored")))) continue;
                this.energy += NumberUtils.toInt((String)storedAsString, (int)0);
            }
            this.energy = Math.round((float)this.energy / 2.5f);
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            this.energyToExtract = energyToExtract;
            return this.energy - energyToExtract >= 0;
        }

        @Override
        public void use() {
            this.energyToExtract = Math.round((float)this.energyToExtract * 2.5f);
            for (Tag energyContainer : this.tagEnergyContainers) {
                if (!(energyContainer instanceof CompoundTag)) continue;
                CompoundTag compound = (CompoundTag)energyContainer;
                String storedAsString = compound.getString("stored");
                int stored = 0;
                if (NumberUtils.isParsable((String)storedAsString)) {
                    stored = NumberUtils.toInt((String)storedAsString, (int)0);
                }
                int energyAfterExtract = Math.max(0, stored - this.energyToExtract);
                this.energyToExtract = stored - energyAfterExtract;
                compound.putString("stored", Integer.toString(energyAfterExtract));
                if (this.energyToExtract > 0) continue;
                break;
            }
            this.stack.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.tag)).build());
        }
    }

    public static class IC2
    extends EnergyHandler {
        private static final double EU_CONVERSION_MODIFIER = 4.0;
        private double energy;
        private double energyAfterUsage;

        public IC2(ItemStack stack, CompoundTag tag) {
            super(stack, tag);
            this.energy = tag.getDouble("charge");
        }

        @Override
        public boolean canBeUsed(int energyToExtract) {
            double realEnergyToExtract = (double)energyToExtract / 4.0;
            this.energyAfterUsage = this.energy - realEnergyToExtract;
            return this.energyAfterUsage >= 0.0;
        }

        @Override
        public void use() {
            this.tag.putDouble("charge", this.energyAfterUsage);
            this.stack.applyComponents(DataComponentPatch.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.tag)).build());
        }
    }
}

