/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.client.render.entity.model;

import com.izofar.takesapillage.common.entity.ClayGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public final class ClayGolemModel
extends HierarchicalModel<ClayGolem> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public ClayGolemModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 21).addBox(-4.0f, -11.0f, -5.5f, 8.0f, 9.0f, 8.0f).texOffs(0, 0).addBox(-1.0f, -5.0f, -7.5f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -2.0f, -5.0f, 14.0f, 12.0f, 9.0f).texOffs(36, 38).addBox(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(18, 21).addBox(-10.0f, -2.5f, -3.0f, 3.0f, 25.0f, 6.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 21).addBox(7.0f, -2.5f, -3.0f, 3.0f, 25.0f, 6.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(31, 49).addBox(-9.5f, -3.0f, -3.0f, 4.0f, 16.0f, 5.0f), PartPose.offset((float)4.0f, (float)11.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(46, 0).addBox(6.5f, -3.0f, -3.0f, 4.0f, 16.0f, 5.0f), PartPose.offset((float)-5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(ClayGolem clayGolem, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.right_leg.xRot = -1.5f * Mth.triangleWave((float)limbAngle, (float)13.0f) * limbDistance;
        this.left_leg.xRot = 1.5f * Mth.triangleWave((float)limbAngle, (float)13.0f) * limbDistance;
        this.right_leg.yRot = 0.0f;
        this.left_leg.yRot = 0.0f;
        int i = clayGolem.getAttackAnimationTick();
        if (i > 0) {
            this.right_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - headYaw), (float)10.0f);
            this.left_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - headYaw), (float)10.0f);
        } else {
            int j = clayGolem.getOfferFlowerTick();
            if (j > 0) {
                this.right_arm.xRot = -0.8f + 0.025f * Mth.triangleWave((float)j, (float)70.0f);
                this.left_arm.xRot = 0.0f;
            } else {
                this.right_arm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbAngle, (float)13.0f)) * limbDistance;
                this.left_arm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbAngle, (float)13.0f)) * limbDistance;
            }
        }
    }

    public ModelPart getFlowerHoldingArm() {
        return this.right_arm;
    }
}

