/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.data;

import com.direwolf20.mininggadgets.common.data.GeneratorBlockStates;
import com.direwolf20.mininggadgets.common.data.GeneratorBlockTags;
import com.direwolf20.mininggadgets.common.data.GeneratorItemModels;
import com.direwolf20.mininggadgets.common.data.GeneratorLanguage;
import com.direwolf20.mininggadgets.common.data.GeneratorLoot;
import com.direwolf20.mininggadgets.common.data.GeneratorRecipes;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="mininggadgets", bus=EventBusSubscriber.Bus.MOD)
public class Generator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        boolean includeServer = event.includeServer();
        boolean includeClient = event.includeClient();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(includeClient, (DataProvider)new GeneratorLanguage(packOutput));
        generator.addProvider(includeClient, (DataProvider)new GeneratorItemModels(packOutput, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(GeneratorLoot::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        generator.addProvider(includeServer, (DataProvider)new GeneratorRecipes(packOutput, event.getLookupProvider()));
        generator.addProvider(includeServer, (DataProvider)new GeneratorBlockTags(packOutput, event.getLookupProvider(), generator, helper));
        generator.addProvider(includeServer, (DataProvider)new GeneratorBlockStates(packOutput, helper));
    }
}

