/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.capabilities;

import com.direwolf20.mininggadgets.setup.MGDataComponents;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.EnergyStorage;

public class EnergyStorageItemstack
extends EnergyStorage {
    protected final ItemStack itemStack;

    public EnergyStorageItemstack(int capacity, ItemStack itemStack) {
        super(EnergyStorageItemstack.getMaxCapacity(itemStack, capacity), Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.itemStack = itemStack;
        this.energy = (Integer)itemStack.getOrDefault(MGDataComponents.FORGE_ENERGY, (Object)0);
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.itemStack.set(MGDataComponents.FORGE_ENERGY, (Object)energy);
    }

    private static int getMaxCapacity(ItemStack stack, int capacity) {
        return (Integer)stack.getOrDefault(MGDataComponents.FORGE_ENERGY_MAX_ENERGY, (Object)capacity);
    }

    public void updatedMaxEnergy(int max) {
        this.itemStack.set(MGDataComponents.FORGE_ENERGY_MAX_ENERGY, (Object)max);
        this.capacity = max;
        this.energy = Math.min(max, this.energy);
        this.receiveEnergy(1, false);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.itemStack.set(MGDataComponents.FORGE_ENERGY, (Object)this.energy);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.itemStack.set(MGDataComponents.FORGE_ENERGY, (Object)this.energy);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return (Integer)this.itemStack.getOrDefault(MGDataComponents.FORGE_ENERGY, (Object)0);
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public Tag serializeNBT(HolderLookup.Provider provider) {
        return IntTag.valueOf((int)this.getEnergyStored());
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intNbt = (IntTag)nbt;
        this.energy = intNbt.getAsInt();
    }
}

