/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.FishItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.items.ItemStackHandler;

public class AquaFishingBobberEntity
extends FishingHook
implements IEntityWithComplexSpawn {
    private final Random lavaTickRand = new Random();
    private Hook hook;
    private ItemStack fishingLine;
    private ItemStack bobber;
    private ItemStack fishingRod;
    private int luck;

    public AquaFishingBobberEntity(EntityType<? extends AquaFishingBobberEntity> entityType, Level level) {
        super(entityType, level);
    }

    public AquaFishingBobberEntity(Player player, Level level, int luck, int lureSpeed, @Nonnull Hook hook, @Nonnull ItemStack fishingLine, @Nonnull ItemStack bobber, @Nonnull ItemStack rod) {
        super(player, level, luck, lureSpeed);
        this.luck = luck;
        player.fishing = this;
        this.hook = hook;
        this.fishingLine = fishingLine;
        this.bobber = bobber;
        this.fishingRod = rod;
        if (this.hasHook() && hook.getWeight() != null) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(hook.getWeight()));
        }
    }

    @Nonnull
    public Hook getHook() {
        return this.hook;
    }

    public boolean hasHook() {
        return this.hook != Hooks.EMPTY;
    }

    @Nonnull
    public ItemStack getBobber() {
        return this.bobber;
    }

    public boolean hasBobber() {
        return !this.getBobber().isEmpty();
    }

    @Nonnull
    public ItemStack getFishingLine() {
        return this.fishingLine;
    }

    @Nonnull
    public EntityType<?> getType() {
        return (EntityType)AquaEntities.BOBBER.get();
    }

    public int retrieve(@Nonnull ItemStack stack) {
        boolean isAdminRod = (Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get() != false && stack.getItem() == AquaItems.NEPTUNIUM_FISHING_ROD.get();
        Player angler = this.getPlayerOwner();
        Level level = this.level();
        if (!level.isClientSide && angler != null && !this.shouldStopFishing(angler)) {
            int rodDamage = 0;
            ItemFishedEvent event = null;
            if (this.getHookedIn() != null && !isAdminRod) {
                this.pullEntity(this.getHookedIn());
                this.triggerFishingRodHooked((ServerPlayer)angler, stack, Collections.emptyList());
                level.broadcastEntityEvent((Entity)this, (byte)31);
                rodDamage = this.getHookedIn() instanceof ItemEntity ? 3 : 5;
            } else if ((this.nibble > 0 || isAdminRod) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LootParams lootParams = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.getOwner()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withLuck((float)this.luck + angler.getLuck()).create(LootContextParamSets.FISHING);
                List<ItemStack> lootEntries = this.getLoot(lootParams, serverLevel);
                if (lootEntries.isEmpty()) {
                    if (level.dimension() == Level.END) {
                        lootEntries.add(new ItemStack((ItemLike)AquaItems.FISH_BONES.get()));
                    } else if (!level.isEmptyBlock(this.blockPosition()) && level.getFluidState(this.blockPosition()).isSource()) {
                        lootEntries.add(new ItemStack((ItemLike)Items.COD));
                        ResourceLocation biomeFromRegistry = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)level.getBiome(this.blockPosition()).value()));
                        if (biomeFromRegistry != null) {
                            Aquaculture.LOG.error("Loot was empty in Biome: " + String.valueOf(biomeFromRegistry) + ". Please report on Github");
                        }
                    }
                }
                if (!lootEntries.isEmpty()) {
                    ItemStackHandler rodHandler;
                    ItemStack bait;
                    List<ItemStack> doubleLoot;
                    event = new ItemFishedEvent(lootEntries, this.onGround() ? 2 : 1, (FishingHook)this);
                    NeoForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        this.discard();
                        return event.getRodDamage();
                    }
                    this.triggerFishingRodHooked((ServerPlayer)angler, stack, lootEntries);
                    this.spawnLoot(angler, lootEntries);
                    if (this.hasHook() && this.hook.getDoubleCatchChance() > 0.0 && this.random.nextDouble() <= this.hook.getDoubleCatchChance() && !(doubleLoot = this.getLoot(lootParams, serverLevel)).isEmpty()) {
                        NeoForge.EVENT_BUS.post((Event)new ItemFishedEvent(doubleLoot, 0, (FishingHook)this));
                        this.spawnLoot(angler, doubleLoot);
                        this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    }
                    if (!angler.isCreative() && !(bait = (rodHandler = AquaFishingRodItem.getHandler(this.fishingRod)).getStackInSlot(1)).isEmpty()) {
                        if (bait.isDamageableItem()) {
                            bait.hurtAndBreak(1, serverLevel, null, item -> {
                                bait.shrink(1);
                                this.playSound((SoundEvent)AquaSounds.BOBBER_BAIT_BREAK.get(), 0.7f, 0.2f);
                            });
                        } else {
                            bait.shrink(1);
                        }
                        rodHandler.setStackInSlot(1, bait);
                    }
                    rodDamage = 1;
                }
            }
            if (this.onGround()) {
                rodDamage = 2;
            }
            this.discard();
            return event == null ? rodDamage : event.getRodDamage();
        }
        return 0;
    }

    public void triggerFishingRodHooked(ServerPlayer angler, @Nonnull ItemStack stack, List<ItemStack> lootEntries) {
        if (lootEntries.getFirst().getItem() instanceof FishItem) {
            CriteriaTriggers.FISHING_ROD_HOOKED.trigger(angler, stack, (FishingHook)this, List.of(new ItemStack((ItemLike)Items.COD)));
        } else {
            CriteriaTriggers.FISHING_ROD_HOOKED.trigger(angler, stack, (FishingHook)this, lootEntries);
        }
    }

    protected boolean shouldStopFishing(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        boolean isMainHandRod = mainHand.canPerformAction(ItemAbilities.FISHING_ROD_CAST);
        boolean isOffHandRod = offHand.canPerformAction(ItemAbilities.FISHING_ROD_CAST);
        if (!player.isRemoved() && player.isAlive() && (isMainHandRod || isOffHandRod) && !(this.distanceToSqr((Entity)player) > 1024.0)) {
            return false;
        }
        this.discard();
        return true;
    }

    private List<ItemStack> getLoot(LootParams lootParams, ServerLevel serverLevel) {
        ResourceKey<LootTable> lootTableLocation = this.isLavaHookInLava(this, (Level)serverLevel, this.blockPosition()) ? (serverLevel.getLevel().dimensionType().hasCeiling() ? AquaLootTables.NETHER_FISHING : AquaLootTables.LAVA_FISHING) : BuiltInLootTables.FISHING;
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableLocation);
        return lootTable.getRandomItems(lootParams);
    }

    private void spawnLoot(Player angler, List<ItemStack> lootEntries) {
        final Level level = this.level();
        for (ItemStack loot : lootEntries) {
            ItemEntity lootEntity = new ItemEntity(level, this.getX(), this.getY(), this.getZ(), loot){

                public boolean displayFireAnimation() {
                    return false;
                }

                public void lavaHurt() {
                }

                public boolean isInvulnerableTo(@Nonnull DamageSource source) {
                    BlockPos spawnPos = new BlockPos((int)AquaFishingBobberEntity.this.getX(), (int)AquaFishingBobberEntity.this.getY(), (int)AquaFishingBobberEntity.this.getZ());
                    return AquaFishingBobberEntity.this.isLavaHookInLava(AquaFishingBobberEntity.this, level, spawnPos) || super.isInvulnerableTo(source);
                }
            };
            double x = angler.getX() - this.getX();
            double y = angler.getY() - this.getY();
            double z = angler.getZ() - this.getZ();
            lootEntity.setDeltaMovement(x * 0.1, y * 0.1 + Math.sqrt(Math.sqrt(x * x + y * y + z * z)) * 0.08 + (this.hasHook() && this.isLavaHookInLava(this, this.level(), new BlockPos((int)x, (int)y, (int)z)) ? 0.2 : 0.0), z * 0.1);
            level.addFreshEntity((Entity)lootEntity);
            angler.level().addFreshEntity((Entity)new ExperienceOrb(angler.level(), angler.getX(), angler.getY() + 0.5, angler.getZ() + 0.5, this.random.nextInt(6) + 1));
            if (!loot.is(ItemTags.FISHES)) continue;
            angler.awardStat(Stats.FISH_CAUGHT, 1);
        }
    }

    public boolean isLavaHookInLava(AquaFishingBobberEntity bobber, Level world, BlockPos pos) {
        return bobber.hasHook() && bobber.hook.getFluids().contains(FluidTags.LAVA) && world.getFluidState(pos).is(FluidTags.LAVA);
    }

    public void tick() {
        if (this.hasHook() && this.hook.getFluids().contains(FluidTags.LAVA)) {
            if (this.hook.getFluids().contains(FluidTags.WATER) && this.level().getFluidState(this.blockPosition()).is(FluidTags.WATER)) {
                super.tick();
            } else {
                this.lavaFishingTick();
            }
        } else {
            super.tick();
        }
    }

    private void lavaFishingTick() {
        super.baseTick();
        this.lavaTickRand.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        Player angler = this.getPlayerOwner();
        if (angler == null) {
            this.discard();
        } else if (this.level().isClientSide || !this.shouldStopFishing(angler)) {
            boolean isMainHandRod;
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.discard();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos bobberPos = this.blockPosition();
            FluidState fluidState = this.level().getFluidState(bobberPos);
            if (fluidState.is(FluidTags.LAVA)) {
                f = fluidState.getHeight((BlockGetter)this.level(), bobberPos);
            }
            boolean bl = isMainHandRod = f > 0.0f;
            if (this.currentState == FishingHook.FishHookState.FLYING) {
                if (this.getHookedIn() != null) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.currentState = FishingHook.FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (isMainHandRod) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    this.currentState = FishingHook.FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishingHook.FishHookState.HOOKED_IN_ENTITY) {
                    if (this.getHookedIn() != null) {
                        if (!this.getHookedIn().isRemoved() && this.getHookedIn().level().dimension() == this.level().dimension()) {
                            this.setPos(this.getHookedIn().getX(), this.getHookedIn().getY(0.8), this.getHookedIn().getZ());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = FishingHook.FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishingHook.FishHookState.BOBBING) {
                    Vec3 motion = this.getDeltaMovement();
                    double y = this.getY() + motion.y - (double)bobberPos.getY() - (double)f;
                    if (Math.abs(y) < 0.01) {
                        y += Math.signum(y) * 0.1;
                    }
                    this.setDeltaMovement(motion.x * 0.9, motion.y - y * (double)this.random.nextFloat() * 0.2, motion.z * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(bobberPos);
                    }
                    if (isMainHandRod) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.lavaTickRand.nextFloat() * (double)this.lavaTickRand.nextFloat(), 0.0));
                        }
                        if (!this.level().isClientSide) {
                            this.catchingFish(bobberPos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!fluidState.is(FluidTags.LAVA)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.updateRotation();
            if (this.currentState == FishingHook.FishHookState.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    protected void catchingFish(BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)this.level();
        int delay = 1;
        BlockPos posUp = pos.above();
        if (this.random.nextFloat() < 0.25f && serverLevel.isRainingAt(posUp)) {
            ++delay;
        }
        if (this.random.nextFloat() < 0.5f && !serverLevel.canSeeSky(posUp)) {
            --delay;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= delay;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float angle = this.fishAngle * ((float)Math.PI / 180);
                float sin = Mth.sin((float)angle);
                float cos = Mth.cos((float)angle);
                double x = this.getX() + (double)(sin * (float)this.timeUntilHooked * 0.1f);
                double y = (float)Mth.floor((double)this.getBoundingBox().minY) + 1.0f;
                double z = this.getZ() + (double)(cos * (float)this.timeUntilHooked * 0.1f);
                FluidState fluidState = serverLevel.getFluidState(new BlockPos((int)x, (int)(y - 1.0), (int)z));
                float zOffset = sin * 0.04f;
                float xOffset = cos * 0.04f;
                if (fluidState.is(FluidTags.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, x, y - (double)0.1f, z, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FISHING, x, y, z, 0, (double)xOffset, 0.01, (double)(-zOffset), 1.0);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FISHING, x, y, z, 0, (double)(-xOffset), 0.01, (double)zOffset, 1.0);
                }
                if (fluidState.is(FluidTags.LAVA)) {
                    if (this.random.nextFloat() < 0.15f) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, x, y - (double)0.1f, z, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0, (double)xOffset, 0.01, (double)(-zOffset), 1.0);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0, (double)(-xOffset), 0.01, (double)zOffset, 1.0);
                }
                if (this.hasHook() && this.hook.getCatchSound() != null && this.getPlayerOwner() != null) {
                    this.level().playSound(null, this.getPlayerOwner() != null ? this.getPlayerOwner().blockPosition() : this.blockPosition(), this.hook.getCatchSound(), this.getSoundSource(), 0.1f, 0.1f);
                }
            } else {
                Vec3 motion = this.getDeltaMovement();
                this.setDeltaMovement(motion.x, -0.4f * Mth.nextFloat((RandomSource)this.random, (float)0.6f, (float)1.0f), motion.z);
                double boundingBox = this.getBoundingBox().minY + 0.5;
                if (serverLevel.getFluidState(this.blockPosition()).is(FluidTags.WATER)) {
                    this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), boundingBox, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), 0.2);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FISHING, this.getX(), boundingBox, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), 0.2);
                }
                if (serverLevel.getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
                    this.playSound((SoundEvent)AquaSounds.BOBBER_LAND_IN_LAVA.get(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, this.getX(), boundingBox, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), 0.2);
                }
                this.nibble = this.hasHook() && this.hook.getMaxCatchable() > 0 ? Mth.nextInt((RandomSource)this.random, (int)this.hook.getMinCatchable(), (int)this.hook.getMaxCatchable()) : Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
                this.getEntityData().set(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= delay;
            float angle = 0.15f;
            if (this.timeUntilLured < 20) {
                angle = (float)((double)angle + (double)(20 - this.timeUntilLured) * (double)0.05f);
            } else if (this.timeUntilLured < 40) {
                angle = (float)((double)angle + (double)(40 - this.timeUntilLured) * (double)0.02f);
            } else if (this.timeUntilLured < 60) {
                angle = (float)((double)angle + (double)(60 - this.timeUntilLured) * (double)0.01f);
            }
            if (this.random.nextFloat() < angle) {
                double z;
                double y;
                float sin = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float cos = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double x = this.getX() + (double)(Mth.sin((float)sin) * cos * 0.1f);
                FluidState fluidState = serverLevel.getFluidState(new BlockPos((int)x, (int)((y = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (int)(z = this.getZ() + (double)(Mth.cos((float)sin) * cos * 0.1f))));
                if (fluidState.is(FluidTags.WATER)) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, x, y, z, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.nextInt((RandomSource)this.random, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.nextInt((RandomSource)this.random, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed;
        }
    }

    public void lavaHurt() {
        if (!this.hasHook() || this.hasHook() && !this.hook.getFluids().contains(FluidTags.LAVA)) {
            super.lavaHurt();
        }
    }

    public boolean displayFireAnimation() {
        return this.hasHook() && !this.hook.getFluids().contains(FluidTags.LAVA) && super.displayFireAnimation();
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.luck);
        buffer.writeUtf(this.hook.getName() == null ? "" : this.hook.getName());
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.fishingLine);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.bobber);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.fishingRod);
    }

    public void readSpawnData(RegistryFriendlyByteBuf buf) {
        this.luck = buf.readInt();
        String hookName = buf.readUtf();
        if (hookName.isEmpty() || hookName == null) {
            this.hook = Hooks.EMPTY;
        } else {
            Item hookItem = (Item)Hook.HOOKS.get(hookName).get();
            this.hook = ((HookItem)hookItem).getHookType();
        }
        this.fishingLine = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        this.bobber = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        this.fishingRod = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
    }
}

