/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.menu;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import tfar.craftingstation.CommonTagUtil;
import tfar.craftingstation.CraftingStation;
import tfar.craftingstation.ModIntegration;
import tfar.craftingstation.PersistantCraftingContainer;
import tfar.craftingstation.blockentity.CraftingStationBlockEntity;
import tfar.craftingstation.init.ModMenuTypes;
import tfar.craftingstation.network.S2CSideSetSideContainerSlot;
import tfar.craftingstation.platform.Services;
import tfar.craftingstation.util.SideContainerWrapper;

public class CraftingStationMenu
extends AbstractContainerMenu {
    private static final int HIDDEN_SLOT_POS = -2000;
    private static final int SLOTS_PER_ROW = 6;
    public final PersistantCraftingContainer craftMatrix;
    public final ResultContainer craftResult = new ResultContainer();
    public final Level world;
    public final CraftingStationBlockEntity tileEntity;
    private int sideContainerStartIndex;
    private int playerInventoryStartIndex;
    public Map<Direction, ItemStack> blocks = new EnumMap<Direction, ItemStack>(Direction.class);
    public Map<Direction, BlockEntity> blockEntityMap = new EnumMap<Direction, BlockEntity>(Direction.class);
    public final Map<Direction, Component> containerNames = new EnumMap<Direction, Component>(Direction.class);
    private final Player player;
    private final BlockPos pos;
    private int firstSlot;
    private int visibleSideSlotCount;
    private final List<SideContainerSlot> sideSlots = new ArrayList<SideContainerSlot>();
    private final Map<Direction, NonNullList<ItemStack>> lastSyncedStacks = new HashMap<Direction, NonNullList<ItemStack>>();
    protected Direction currentContainer;

    public CraftingStationMenu(int id, Inventory inv, BlockPos pos) {
        this(id, inv, new SimpleContainer(9), pos);
    }

    public CraftingStationMenu(int id, Inventory inv, SimpleContainer simpleContainer, BlockPos pos) {
        super(ModMenuTypes.crafting_station, id);
        this.player = inv.player;
        this.pos = pos;
        this.world = this.player.level();
        this.tileEntity = (CraftingStationBlockEntity)ModIntegration.getTileEntityAtPos(this.player.level(), pos);
        this.setCurrentContainer(this.tileEntity.getCurrentContainer());
        this.craftMatrix = new PersistantCraftingContainer(this, simpleContainer);
        this.addOwnSlots();
        if (Services.PLATFORM.getConfig().sideContainers()) {
            this.searchSideInventories();
        }
        this.addSideInventorySlots();
        this.addPlayerSlots(inv);
        this.slotsChanged((Container)this.craftMatrix);
    }

    public SideContainerWrapper getCurrentHandler() {
        return Services.PLATFORM.getWrapper(this.blockEntityMap.get(this.getSelectedContainer()));
    }

    public SideContainerWrapper getHandlerFor(Direction direction) {
        return Services.PLATFORM.getWrapper(this.blockEntityMap.get(direction));
    }

    protected void addSideInventorySlots() {
        this.setSideContainerStartIndex(10);
        this.visibleSideSlotCount = 0;
        if (!this.hasSideContainers()) {
            return;
        }
        if (this.sideSlots.isEmpty()) {
            for (Direction direction : Direction.values()) {
                SideContainerWrapper wrapper;
                BlockEntity blockEntity = this.blockEntityMap.get(direction);
                if (blockEntity == null || (wrapper = this.getHandlerFor(direction)) == null) continue;
                int slotCount = wrapper.$getSlotCount();
                for (int i = 0; i < slotCount; ++i) {
                    SideContainerSlot slot = new SideContainerSlot(direction, i, -2000, -2000, this);
                    this.sideSlots.add(slot);
                    this.addSlot(slot);
                }
            }
        }
        this.refreshSideSlots();
    }

    public boolean hasSideContainers() {
        return !this.blocks.isEmpty();
    }

    public int subContainerSize() {
        SideContainerWrapper handler = this.getCurrentHandler();
        return handler != null ? handler.$getSlotCount() : 0;
    }

    public Direction getSelectedContainer() {
        return this.currentContainer;
    }

    public void searchSideInventories() {
        Direction defaultDirection = null;
        for (Direction dir : Direction.values()) {
            Container container;
            BlockPos neighbor = this.pos.relative(dir);
            BlockEntity te = this.world.getBlockEntity(neighbor);
            if (te == null || te instanceof CraftingStationBlockEntity || CommonTagUtil.isIn(CraftingStation.blacklisted, te.getType()) || te instanceof Container && !(container = (Container)te).stillValid(this.player) || !Services.PLATFORM.hasCapability(te)) continue;
            this.blockEntityMap.put(dir, te);
            BlockState neighborState = this.world.getBlockState(neighbor);
            ItemStack displayStack = Services.PLATFORM.createSideDisplayStack(this.world, neighbor, neighborState, this.player);
            if (displayStack.isEmpty()) {
                displayStack = new ItemStack((ItemLike)neighborState.getBlock());
            }
            this.blocks.put(dir, displayStack);
            this.containerNames.put(dir, Services.PLATFORM.fixSophisticatedStorageDisplayName(te));
            if (defaultDirection != null || this.currentContainer != Direction.DOWN) continue;
            defaultDirection = dir;
        }
        if (defaultDirection != null) {
            this.currentContainer = defaultDirection;
        }
    }

    private void addOwnSlots() {
        this.addSlot((Slot)new ResultSlot(this.player, (CraftingContainer)this.craftMatrix, (Container)this.craftResult, 0, 124, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.addSlot(new Slot((Container)this.craftMatrix, x + 3 * y, 30 + 18 * x, 17 + 18 * y));
            }
        }
    }

    protected void addPlayerSlots(Inventory playerInventory) {
        this.setPlayerInventoryStartIndex(this.getSideContainerStartIndex(Direction.NORTH) + this.sideSlots.size());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, 9 + x + 9 * y, 8 + 18 * x, 84 + 18 * y));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + 18 * x, 142));
        }
    }

    public void slotsChanged(Container inventory) {
        if (inventory == this.craftMatrix) {
            this.craftMatrix.setDoNotCallUpdates(true);
            try {
                CraftingStationMenu.slotChangedCraftingGrid(this, this.world, this.player, this.craftMatrix, this.craftResult, null);
            }
            finally {
                this.craftMatrix.setDoNotCallUpdates(false);
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack quickMoveStack(Player playerIn, int index) {
        boolean nothingDone;
        if (this.hasSideContainers()) {
            return this.handleTransferWithSides(playerIn, index);
        }
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = slot.getItem().copy();
        ItemStack stack = slot.getItem().copy();
        if (index == 0) {
            this.craftMatrix.setDoNotCallUpdates(true);
            try {
                nothingDone = !this.moveToPlayerInventory(stack);
            }
            finally {
                this.craftMatrix.setDoNotCallUpdates(false);
                this.craftMatrix.setChanged();
            }
        } else if (index < this.sideContainerStartIndex) {
            nothingDone = !this.moveToPlayerInventory(stack);
        } else {
            boolean bl = nothingDone = !this.moveToCraftingStation(stack);
        }
        if (nothingDone) {
            return ItemStack.EMPTY;
        }
        return this.notifySlotAfterTransfer(playerIn, stack, ret, slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ItemStack handleTransferWithSides(Player player, int index) {
        boolean nothingDone;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = slot.getItem().copy();
        ItemStack stack = ret.copy();
        int visibleStartIndex = this.getVisibleSideSlotStartIndex();
        int visibleEndIndex = this.getVisibleSideSlotEndIndex();
        boolean hasVisibleRange = visibleStartIndex >= 0 && visibleEndIndex > visibleStartIndex;
        int allSideStartIndex = this.sideContainerStartIndex;
        int allSideEndIndex = this.sideContainerStartIndex + this.sideSlots.size();
        if (index == 0) {
            this.craftMatrix.setDoNotCallUpdates(true);
            try {
                nothingDone = !this.refillSideInventory(stack);
                nothingDone &= !this.moveToPlayerInventory(stack);
                boolean merged = false;
                if (hasVisibleRange) {
                    merged = this.mergeItemStackMove(stack, visibleStartIndex, visibleEndIndex);
                }
                nothingDone &= !merged;
            }
            finally {
                this.craftMatrix.setDoNotCallUpdates(false);
                this.craftMatrix.setChanged();
            }
        } else if (index < this.sideContainerStartIndex) {
            nothingDone = !this.refillSideInventory(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
            nothingDone &= !this.moveToSideInventory(stack);
        } else if (hasVisibleRange && index >= visibleStartIndex && index < visibleEndIndex) {
            nothingDone = !this.moveToCraftingStation(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
        } else {
            if (index >= allSideStartIndex && index < allSideEndIndex) {
                return ItemStack.EMPTY;
            }
            if (index >= allSideEndIndex) {
                nothingDone = !this.moveToCraftingStation(stack);
                nothingDone &= !this.moveToSideInventory(stack);
            } else {
                return ItemStack.EMPTY;
            }
        }
        if (nothingDone) {
            return ItemStack.EMPTY;
        }
        return this.notifySlotAfterTransfer(player, stack, ret, slot);
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu pMenu, Level pLevel, Player pPlayer, CraftingContainer pCraftSlots, ResultContainer pResultSlots, RecipeHolder<CraftingRecipe> pRecipe) {
        if (!pLevel.isClientSide) {
            CraftingInput craftinginput = pCraftSlots.asCraftInput();
            ServerPlayer serverplayer = (ServerPlayer)pPlayer;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = pLevel.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftinginput, pLevel, pRecipe);
            if (optional.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder recipeholder = (RecipeHolder)optional.get();
                CraftingRecipe craftingrecipe = (CraftingRecipe)recipeholder.value();
                if (pResultSlots.setRecipeUsed(pLevel, serverplayer, recipeholder) && (itemstack1 = craftingrecipe.assemble((RecipeInput)craftinginput, (HolderLookup.Provider)pLevel.registryAccess())).isItemEnabled(pLevel.enabledFeatures())) {
                    itemstack = itemstack1;
                }
            }
            pResultSlots.setItem(0, itemstack);
            pMenu.setRemoteSlot(0, itemstack);
            pMenu.broadcastFullState();
        }
    }

    public boolean sameGui(CraftingStationMenu otherContainer) {
        return this.tileEntity == otherContainer.tileEntity;
    }

    protected ItemStack notifySlotAfterTransfer(Player player, ItemStack stack, ItemStack original, Slot slot) {
        slot.onQuickCraft(stack, original);
        if (stack.getCount() == original.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.set(stack);
        slot.onTake(player, stack);
        if (slot.hasItem() && slot.getItem().isEmpty()) {
            slot.set(ItemStack.EMPTY);
        }
        return original;
    }

    protected boolean moveToSideInventory(ItemStack stack) {
        int i;
        if (!this.hasSideContainers()) {
            return false;
        }
        SideContainerWrapper wrapper = this.getCurrentHandler();
        if (wrapper == null) {
            return false;
        }
        boolean moved = false;
        ItemStack remaining = stack.copy();
        for (i = 0; i < wrapper.$getSlotCount(); ++i) {
            ItemStack result;
            ItemStack inSlot;
            if (!wrapper.$valid(i) || (inSlot = wrapper.$getStack(i)).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)remaining, (ItemStack)inSlot) || (result = wrapper.$insert(i, remaining, false)).getCount() == remaining.getCount()) continue;
            remaining = result;
            moved = true;
            if (remaining.isEmpty()) break;
        }
        if (!remaining.isEmpty()) {
            for (i = 0; i < wrapper.$getSlotCount(); ++i) {
                ItemStack result;
                if (!wrapper.$valid(i) || !wrapper.$getStack(i).isEmpty() || (result = wrapper.$insert(i, remaining, false)).getCount() == remaining.getCount()) continue;
                remaining = result;
                moved = true;
                if (remaining.isEmpty()) break;
            }
        }
        if (moved) {
            stack.setCount(remaining.getCount());
        }
        return moved;
    }

    protected boolean moveToPlayerInventory(ItemStack stack) {
        int start = this.sideContainerStartIndex + (this.hasSideContainers() ? this.sideSlots.size() : 0);
        return this.moveItemStackTo(stack, start, this.slots.size(), true);
    }

    protected boolean refillSideInventory(ItemStack itemStack) {
        return this.mergeItemStackRefillSideContainer(itemStack, 0, this.subContainerSize());
    }

    protected boolean moveToCraftingStation(ItemStack itemstack) {
        return this.moveItemStackTo(itemstack, 1, this.sideContainerStartIndex, false);
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean didSomething = this.mergeItemStackRefill(stack, startIndex, endIndex);
        if (!stack.isEmpty()) {
            didSomething |= this.mergeItemStackMove(stack, startIndex, endIndex);
        }
        return didSomething;
    }

    protected boolean mergeItemStackRefill(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        boolean didSomething = false;
        if (stack.isStackable()) {
            for (int k = startIndex; k < endIndex && !stack.isEmpty(); ++k) {
                int limit;
                Slot targetSlot = (Slot)this.slots.get(k);
                ItemStack slotStack = targetSlot.getItem();
                if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack) || !this.canTakeItemForPickAll(stack, targetSlot)) continue;
                int l = slotStack.getCount() + stack.getCount();
                if (l <= (limit = targetSlot.getMaxStackSize(stack))) {
                    stack.setCount(0);
                    slotStack.setCount(l);
                    targetSlot.setChanged();
                    didSomething = true;
                    continue;
                }
                if (slotStack.getCount() >= limit) continue;
                stack.shrink(limit - slotStack.getCount());
                slotStack.setCount(limit);
                targetSlot.setChanged();
                didSomething = true;
            }
        }
        return didSomething;
    }

    protected boolean mergeItemStackMove(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(this.slots.size(), endIndex);
        boolean didSomething = false;
        for (int k = startIndex; k < endIndex; ++k) {
            Slot targetSlot = (Slot)this.slots.get(k);
            ItemStack slotStack = targetSlot.getItem();
            if (!slotStack.isEmpty() || !targetSlot.mayPlace(stack) || !this.canTakeItemForPickAll(stack, targetSlot)) continue;
            int limit = targetSlot.getMaxStackSize(stack);
            ItemStack stack2 = stack.copy();
            if (stack2.getCount() > limit) {
                stack2.setCount(limit);
                stack.shrink(limit);
            } else {
                stack.setCount(0);
            }
            targetSlot.set(stack2);
            targetSlot.setChanged();
            didSomething = true;
            if (stack.isEmpty()) break;
        }
        return didSomething;
    }

    protected boolean mergeItemStackMoveSideContainer(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        boolean didSomething = false;
        SideContainerWrapper sideContainerWrapper = this.getCurrentHandler();
        ItemStack remainder = stack.copy();
        for (int k = startIndex; k < endIndex; ++k) {
            ItemStack slotStack = sideContainerWrapper.$getStack(k);
            if (!slotStack.isEmpty() || !sideContainerWrapper.$valid(k)) continue;
            boolean bl = didSomething = (remainder = sideContainerWrapper.$insert(k, remainder, false)) != stack;
            if (remainder.isEmpty()) break;
        }
        if (didSomething) {
            stack.setCount(remainder.getCount());
        }
        return didSomething;
    }

    protected boolean mergeItemStackRefillSideContainer(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        SideContainerWrapper sideContainerWrapper = this.getCurrentHandler();
        boolean didSomething = false;
        if (stack.isStackable()) {
            ItemStack remainder = stack.copy();
            for (int k = startIndex; k < endIndex && !stack.isEmpty(); ++k) {
                ItemStack slotStack = sideContainerWrapper.$getStack(k);
                if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) continue;
                boolean bl = didSomething = (remainder = sideContainerWrapper.$insert(k, remainder, false)) != stack;
                if (remainder.isEmpty()) break;
            }
            if (didSomething) {
                stack.setCount(remainder.getCount());
            }
        }
        return didSomething;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.craftResult && super.canTakeItemForPickAll(stack, slot);
    }

    public boolean needsScroll() {
        SideContainerWrapper handler = this.getCurrentHandler();
        if (handler == null) {
            return false;
        }
        return handler.$getSlotCount() > 54;
    }

    public void setCurrentContainer(Direction currentContainer) {
        this.currentContainer = currentContainer;
        this.firstSlot = 0;
        this.refreshSideSlots();
    }

    public boolean clickMenuButton(Player pPlayer, int id) {
        if (id < 0 || id >= ButtonAction.VALUES.length) {
            return false;
        }
        ButtonAction buttonAction = ButtonAction.VALUES[id];
        if (pPlayer instanceof ServerPlayer) {
            switch (buttonAction.ordinal()) {
                case 0: {
                    for (int i = 1; i < 10; ++i) {
                        this.quickMoveStack(this.player, i);
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Direction direction = Direction.values()[id - 1];
                    if (this.blockEntityMap.get(direction) == null) break;
                    this.setCurrentContainer(direction);
                }
            }
        }
        return true;
    }

    public void removed(Player $$0) {
        super.removed($$0);
        if (!$$0.level().isClientSide) {
            this.tileEntity.setCurrentContainer(this.currentContainer);
        }
    }

    public void setFirstSlot(int firstSlot) {
        SideContainerWrapper handler = this.getCurrentHandler();
        if (handler == null) {
            this.firstSlot = 0;
            return;
        }
        int maxOffset = Math.max(0, handler.$getSlotCount() - 54);
        this.firstSlot = Mth.clamp((int)firstSlot, (int)0, (int)maxOffset);
        this.refreshSideSlots();
    }

    public int getFirstSlot() {
        return this.firstSlot;
    }

    public int getVisibleSideSlotCount() {
        return this.visibleSideSlotCount;
    }

    private void refreshSideSlots() {
        SideContainerWrapper handler = this.getCurrentHandler();
        int totalSlots = handler != null ? handler.$getSlotCount() : 0;
        int maxOffset = Math.max(0, totalSlots - 54);
        this.firstSlot = Mth.clamp((int)this.firstSlot, (int)0, (int)maxOffset);
        int available = Math.max(0, totalSlots - this.firstSlot);
        this.visibleSideSlotCount = Math.min(available, 54);
        if (this.sideSlots.isEmpty()) {
            return;
        }
        boolean scrolling = totalSlots > 54;
        int xOffset = scrolling ? -125 : -117;
        Direction selected = this.getSelectedContainer();
        for (int i = 0; i < this.sideSlots.size(); ++i) {
            int displayIndex;
            SideContainerSlot existing = this.sideSlots.get(i);
            Direction slotDirection = existing.getDirection();
            int actualSlot = existing.getActualSlot();
            int xPos = -2000;
            int yPos = -2000;
            if (slotDirection == selected && actualSlot >= this.firstSlot && actualSlot < totalSlots && (displayIndex = actualSlot - this.firstSlot) >= 0 && displayIndex < this.visibleSideSlotCount) {
                int row = displayIndex / 6;
                int col = displayIndex % 6;
                xPos = xOffset + col * 18;
                yPos = 17 + row * 18;
            }
            if (existing.x == xPos && existing.y == yPos) continue;
            SideContainerSlot replacement = new SideContainerSlot(slotDirection, actualSlot, xPos, yPos, this);
            replacement.index = existing.index;
            this.sideSlots.set(i, replacement);
            int slotListIndex = this.sideContainerStartIndex + i;
            if (slotListIndex >= this.slots.size()) continue;
            this.slots.set(slotListIndex, (Object)replacement);
        }
    }

    private int getSelectedSideSlotOffset() {
        Direction selected = this.getSelectedContainer();
        for (int i = 0; i < this.sideSlots.size(); ++i) {
            if (this.sideSlots.get(i).getDirection() != selected) continue;
            return i;
        }
        return -1;
    }

    private int getSelectedSideSlotContainerStart() {
        int offset = this.getSelectedSideSlotOffset();
        if (offset < 0) {
            return -1;
        }
        return this.sideContainerStartIndex + offset;
    }

    private int getVisibleSideSlotStartIndex() {
        int base = this.getSelectedSideSlotContainerStart();
        if (base < 0) {
            return -1;
        }
        return base + this.getFirstSlot();
    }

    private int getVisibleSideSlotEndIndex() {
        int start = this.getVisibleSideSlotStartIndex();
        if (start < 0) {
            return -1;
        }
        return start + this.getVisibleSideSlotCount();
    }

    private boolean isValidSideSlot(SideContainerWrapper handler, int slot) {
        return handler != null && slot >= 0 && slot < handler.$getSlotCount();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.hasSideContainers()) {
            this.syncSideContainers();
        }
    }

    public void syncSideContainers() {
        for (Map.Entry<Direction, BlockEntity> entry : this.blockEntityMap.entrySet()) {
            Direction direction = entry.getKey();
            BlockEntity blockEntity = entry.getValue();
            SideContainerWrapper wrapper = Services.PLATFORM.getWrapper(blockEntity);
            if (wrapper == null) continue;
            int slotCount = wrapper.$getSlotCount();
            NonNullList lastSynced = this.lastSyncedStacks.computeIfAbsent(direction, d -> NonNullList.withSize((int)slotCount, (Object)ItemStack.EMPTY));
            if (lastSynced.size() != slotCount) {
                lastSynced = NonNullList.withSize((int)slotCount, (Object)ItemStack.EMPTY);
                this.lastSyncedStacks.put(direction, (NonNullList<ItemStack>)lastSynced);
            }
            for (int i = 0; i < slotCount; ++i) {
                ItemStack previous;
                ItemStack current = wrapper.$getStack(i);
                if (ItemStack.matches((ItemStack)current, (ItemStack)(previous = (ItemStack)lastSynced.get(i)))) continue;
                Services.PLATFORM.sendToClient(new S2CSideSetSideContainerSlot(current, direction, i), (ServerPlayer)this.player);
                lastSynced.set(i, (Object)current.copy());
            }
        }
    }

    public void synchronizeSlotToRemote(int pSlotIndex, ItemStack pStack, Supplier<ItemStack> pSupplier) {
        if (!this.suppressRemoteUpdates) {
            ItemStack itemstack = (ItemStack)this.remoteSlots.get(pSlotIndex);
            ItemStack itemstack1 = pSupplier.get();
            this.remoteSlots.set(pSlotIndex, (Object)itemstack1);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange((AbstractContainerMenu)this, pSlotIndex, itemstack1);
            }
        }
    }

    public int getSideContainerStartIndex(Direction direction) {
        if (this.blockEntityMap.containsKey(direction)) {
            return this.sideContainerStartIndex;
        }
        return 0;
    }

    public void setSideContainerStartIndex(int startIndex) {
        this.sideContainerStartIndex = startIndex;
    }

    public int getPlayerInventoryStartIndex() {
        return this.playerInventoryStartIndex;
    }

    public void setPlayerInventoryStartIndex(int startIndex) {
        this.playerInventoryStartIndex = startIndex;
    }

    public static class SideContainerSlot
    extends Slot {
        private final CraftingStationMenu craftingStationMenu;
        private final Direction direction;
        private final int slotIndex;

        public SideContainerSlot(Direction direction, int slotIndex, int x, int y, CraftingStationMenu craftingStationMenu) {
            super((Container)new SimpleContainer(0), slotIndex, x, y);
            this.craftingStationMenu = craftingStationMenu;
            this.direction = direction;
            this.slotIndex = slotIndex;
        }

        private SideContainerWrapper getHandler() {
            return this.craftingStationMenu.getHandlerFor(this.direction);
        }

        public ItemStack getItem() {
            SideContainerWrapper handler = this.getHandler();
            if (!this.craftingStationMenu.isValidSideSlot(handler, this.slotIndex)) {
                return ItemStack.EMPTY;
            }
            return handler.$getStack(this.slotIndex);
        }

        public ItemStack remove(int amount) {
            SideContainerWrapper handler = this.getHandler();
            if (!this.craftingStationMenu.isValidSideSlot(handler, this.slotIndex)) {
                return ItemStack.EMPTY;
            }
            return handler.$removeStack(this.slotIndex, amount);
        }

        public boolean mayPlace(ItemStack stack) {
            SideContainerWrapper handler = this.getHandler();
            return this.craftingStationMenu.isValidSideSlot(handler, this.slotIndex) && handler.$valid(this.slotIndex);
        }

        public void set(ItemStack stack) {
            SideContainerWrapper handler = this.getHandler();
            if (this.craftingStationMenu.isValidSideSlot(handler, this.slotIndex)) {
                handler.$setStack(this.slotIndex, stack);
            }
        }

        public int getMaxStackSize() {
            SideContainerWrapper handler = this.getHandler();
            return this.craftingStationMenu.isValidSideSlot(handler, this.slotIndex) ? handler.$getMaxStackSize(this.slotIndex) : 0;
        }

        public boolean isFake() {
            SideContainerWrapper handler = this.getHandler();
            return !this.craftingStationMenu.isValidSideSlot(handler, this.slotIndex);
        }

        public int getActualSlot() {
            return this.slotIndex;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }

    public static enum ButtonAction {
        CLEAR,
        TAB_0,
        TAB_1,
        TAB_2,
        TAB_3,
        TAB_4,
        TAB_5;

        static final ButtonAction[] VALUES;

        static {
            VALUES = ButtonAction.values();
        }
    }
}

