/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_wap.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.ElectricitySourceLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.NodeSearchResult;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import dev.tr3ymix.cfm_wap.Config;
import dev.tr3ymix.cfm_wap.block.CircuitBreakerBlock;
import dev.tr3ymix.cfm_wap.blockentity.CircuitBreakerCache;
import dev.tr3ymix.cfm_wap.blockentity.IProcessingCircuitBreakerBlock;
import dev.tr3ymix.cfm_wap.energy.CommonEnergyStorage;
import dev.tr3ymix.cfm_wap.inventory.CircuitBreakerMenu;
import dev.tr3ymix.cfm_wap.registry.ModBlockEntities;
import dev.tr3ymix.cfm_wap.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CircuitBreakerBlockEntity
extends ElectricitySourceLootBlockEntity
implements IProcessingCircuitBreakerBlock,
IPowerSwitch {
    protected final Vec3 centerPosition;
    protected boolean enabled;
    protected int nodeCount;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(Integer.valueOf(0), this::getEnergy, value -> {});
        builder.add(Integer.valueOf(1), this::getMaxEnergy, value -> {});
        builder.add(Integer.valueOf(2), () -> this.enabled ? 1 : 0, value -> {});
        builder.add(Integer.valueOf(3), () -> this.overloaded ? 1 : 0, value -> {});
        builder.add(Integer.valueOf(4), () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(Integer.valueOf(5), () -> this.nodeCount, value -> {});
    });
    public final CommonEnergyStorage ENERGY_STORAGE = new CommonEnergyStorage(1000, 50);
    int ENERGY_RATE = 10;

    public CircuitBreakerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CIRCUIT_BREAKER.get(), pos, state);
    }

    public CircuitBreakerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 1);
        this.centerPosition = pos.getCenter();
    }

    public int getNodeMaximumConnections() {
        return (Integer)Config.SERVER.electricity.maximumLinksPerCircuitBreaker.get();
    }

    @NotNull
    protected Component getDefaultName() {
        return Utils.translation("container", "circuit_breaker", new Object[0]);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        if (!this.enabled) {
            this.searchNodeNetwork(false);
        }
        return new CircuitBreakerMenu(i, inventory, (Container)this, this.data);
    }

    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        if (menu instanceof CircuitBreakerMenu) {
            CircuitBreakerMenu circuitBreaker = (CircuitBreakerMenu)menu;
            return circuitBreaker.getContainer() == this;
        }
        return false;
    }

    public boolean isNodePowered() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)CircuitBreakerBlock.POWERED) ? (Boolean)state.getValue((Property)CircuitBreakerBlock.POWERED) : false;
    }

    public void setNodePowered(boolean powered) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)CircuitBreakerBlock.POWERED)) {
            assert (this.level != null);
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)CircuitBreakerBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public void togglePower() {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            NodeSearchResult result = this.searchNodeNetwork(false);
            if (!result.overloaded()) {
                if (this.overloaded) {
                    this.overloaded = false;
                }
            } else {
                this.enabled = false;
            }
        }
        this.setChanged();
    }

    public void onNodeOverloaded() {
        this.enabled = false;
        this.setChanged();
    }

    public NodeSearchResult searchNodeNetwork(boolean cancelAtLimit) {
        List nodes = IElectricityNode.searchNodes((IElectricityNode)this, (int)((Integer)Config.SERVER.electricity.maximumNodesInCircuitBreakerNetwork.get()), (boolean)cancelAtLimit, node -> !node.isSourceNode() && node.canPowerTraverseNode(), node -> !node.isSourceNode());
        boolean overloaded = nodes.size() > (Integer)Config.SERVER.electricity.maximumNodesInCircuitBreakerNetwork.get();
        NodeSearchResult result = new NodeSearchResult(overloaded, nodes);
        this.nodeCount = result.nodes().size();
        return result;
    }

    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergy();
    }

    @Override
    public int getMaxEnergy() {
        return this.ENERGY_STORAGE.getCapacity();
    }

    @Override
    public int getEnergyRate() {
        return this.ENERGY_RATE;
    }

    public void addEnergy(int amount) {
        this.ENERGY_STORAGE.setEnergy(amount);
        this.setChanged();
    }

    @Override
    public void removeEnergy(int amount) {
        this.ENERGY_STORAGE.extractEnergy(amount, false);
    }

    public boolean requiresEnergy() {
        return true;
    }

    public int retrieveEnergy(boolean simulate) {
        if (!simulate) {
            return this.ENERGY_STORAGE.insertEnergy(this.ENERGY_RATE, false);
        }
        return 0;
    }

    public int updateAndGetTotalProcessingTime() {
        return this.getTotalProcessingTime();
    }

    public int getTotalProcessingTime() {
        return 1;
    }

    public int getProcessingTime() {
        return 0;
    }

    public void setProcessingTime(int time) {
        if (this.isNodePowered()) {
            if (time == 0) {
                this.setNodePowered(false);
            }
        } else if (time == 1) {
            this.setNodePowered(true);
        }
    }

    public void onCompleteProcess() {
    }

    public boolean canProcess() {
        return this.enabled && !this.isNodeOverloaded();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide) {
            CircuitBreakerCache.add(level, this.getBlockPos());
        }
    }

    public void setRemoved() {
        assert (this.level != null);
        if (!this.level.isClientSide) {
            CircuitBreakerCache.remove(this.level, this.getBlockPos());
        }
        super.setRemoved();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Enabled", 1)) {
            this.enabled = tag.getBoolean("Enabled");
        }
        if (tag.contains("Energy", 3)) {
            this.ENERGY_STORAGE.setEnergy(tag.getInt("Energy"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("Enabled", this.enabled);
        tag.putInt("Energy", this.ENERGY_STORAGE.getEnergy());
    }

    public void earlyNodeTick(Level level) {
        if (!level.isClientSide) {
            this.processTick();
        }
        super.earlyNodeTick(level);
    }

    public void onOpen(Level level, BlockPos pos, BlockState state) {
        level.playSound(null, this.centerPosition.x, this.centerPosition.y, this.centerPosition.z, (SoundEvent)ModSounds.BLOCK_STOVE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, true);
    }

    public void onClose(Level level, BlockPos pos, BlockState state) {
        level.playSound(null, this.centerPosition.x, this.centerPosition.y, this.centerPosition.z, (SoundEvent)ModSounds.BLOCK_MICROWAVE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)CircuitBreakerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

