/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.vertical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedVerticalSlicedStairsBlock
extends FramedVerticalStairsBlock
implements IFramedDoubleBlock {
    public FramedVerticalSlicedStairsBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.RIGHT});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state == null) {
            return null;
        }
        Direction face = ctx.getClickedFace();
        Direction fracDir = Utils.isY(face) ? ctx.getHorizontalDirection().getClockWise() : face.getCounterClockWise();
        boolean right = Utils.fractionInDir(ctx.getClickLocation(), fracDir) > 0.5;
        return (BlockState)state.setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        if (right) {
            return switch ((StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE))) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())));
                case StairsType.TOP_FWD -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())));
                case StairsType.TOP_CCW -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())));
                case StairsType.TOP_BOTH -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())));
                case StairsType.BOTTOM_FWD -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())));
                case StairsType.BOTTOM_CCW -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
                case StairsType.BOTTOM_BOTH -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            };
        }
        return switch ((StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE))) {
            default -> throw new MatchException(null, null);
            case StairsType.VERTICAL -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())));
            case StairsType.TOP_FWD -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())));
            case StairsType.TOP_CCW -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())));
            case StairsType.TOP_BOTH -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())));
            case StairsType.BOTTOM_FWD -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            case StairsType.BOTTOM_CCW -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())));
            case StairsType.BOTTOM_BOTH -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsType type = (StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE));
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        if (side == facing && !type.isForward()) {
            return right ? SolidityCheck.FIRST : SolidityCheck.BOTH;
        }
        if (side == facing.getCounterClockWise() && !type.isCounterClockwise()) {
            return right ? SolidityCheck.BOTH : SolidityCheck.FIRST;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsType type = (StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE));
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        if (side == facing) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.TOP_CCW, StairsType.BOTTOM_CCW -> {
                    if (!right) {
                        if (edge == facing.getCounterClockWise()) {
                            yield CamoGetter.FIRST;
                        }
                        if (edge == facing.getClockWise()) {
                            yield CamoGetter.SECOND;
                        }
                        yield CamoGetter.NONE;
                    }
                    yield CamoGetter.FIRST;
                }
                case StairsType.TOP_FWD, StairsType.TOP_BOTH -> {
                    if (edge == facing.getCounterClockWise() || right && edge == Direction.DOWN) {
                        yield CamoGetter.FIRST;
                    }
                    yield CamoGetter.NONE;
                }
                case StairsType.BOTTOM_FWD, StairsType.BOTTOM_BOTH -> edge == facing.getCounterClockWise() || right && edge == Direction.UP ? CamoGetter.FIRST : CamoGetter.NONE;
            };
        }
        if (side == facing.getCounterClockWise()) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.TOP_FWD, StairsType.BOTTOM_FWD -> {
                    if (right) {
                        if (edge == facing) {
                            yield CamoGetter.FIRST;
                        }
                        if (edge == facing.getOpposite()) {
                            yield CamoGetter.SECOND;
                        }
                        yield CamoGetter.NONE;
                    }
                    yield CamoGetter.FIRST;
                }
                case StairsType.TOP_CCW, StairsType.TOP_BOTH -> {
                    if (edge == facing || !right && edge == Direction.DOWN) {
                        yield CamoGetter.FIRST;
                    }
                    yield CamoGetter.NONE;
                }
                case StairsType.BOTTOM_CCW, StairsType.BOTTOM_BOTH -> edge == facing || !right && edge == Direction.UP ? CamoGetter.FIRST : CamoGetter.NONE;
            };
        }
        if (side == Direction.UP) {
            if (!(right || type.isTop() && type.isCounterClockwise() || edge != facing.getCounterClockWise())) {
                return CamoGetter.FIRST;
            }
            if (!(!right || type.isTop() && type.isForward() || edge != facing)) {
                return CamoGetter.FIRST;
            }
            return CamoGetter.NONE;
        }
        if (side == Direction.DOWN) {
            if (!(right || type.isBottom() && type.isCounterClockwise() || edge != facing.getCounterClockWise())) {
                return CamoGetter.FIRST;
            }
            if (!(!right || type.isBottom() && type.isForward() || edge != facing)) {
                return CamoGetter.FIRST;
            }
            return CamoGetter.NONE;
        }
        if (side == facing.getOpposite()) {
            if (edge == facing.getCounterClockWise() && !type.isCounterClockwise()) {
                return right ? CamoGetter.SECOND : CamoGetter.FIRST;
            }
            return CamoGetter.NONE;
        }
        if (side == facing.getClockWise()) {
            if (edge == facing && !type.isForward()) {
                return right ? CamoGetter.SECOND : CamoGetter.FIRST;
            }
            return CamoGetter.NONE;
        }
        return CamoGetter.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH)).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
            builder.put((Object)state, (Object)CommonShapes.STRAIGHT_VERTICAL_STAIRS.get(right ? dir.getClockWise() : dir));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

