/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.epherical.croptopia.register.helpers.Utensil;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class CroptopiaItemTagProvider
extends IntrinsicHolderTagsProvider<Item> {
    public CroptopiaItemTagProvider(PackOutput output, ResourceKey<? extends Registry<Item>> registryKey, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, registryKey, lookupProvider, item -> item.builtInRegistryHolder().key(), "croptopia", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider arg) {
        this.generateSaplings();
        this.generateBarkLogs();
        this.generateMisc();
        this.generateSeedsEatenByTag((TagKey<Item>)ItemTags.CHICKEN_FOOD);
        this.generateSeedsEatenByTag((TagKey<Item>)ItemTags.PARROT_FOOD);
        this.generateToolsTags((TagKey<Item>)Tags.Items.TOOLS);
    }

    protected void generateToolsTags(TagKey<Item> key) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(key);
        for (Utensil utensil : Utensil.copy()) {
            tag.add((Object)utensil.asItem());
        }
        IntrinsicHolderTagsProvider.IntrinsicTagAppender c = this.tag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/knife")));
        c.add((Object)Content.KNIFE.asItem());
    }

    protected void generateSeedsEatenByTag(TagKey<Item> key) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(key);
        for (Item seed : CroptopiaMod.seeds) {
            tag.add((Object)seed);
        }
    }

    protected void generateSaplings() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender saplings = this.tag(ItemTags.SAPLINGS);
        for (TreeCrop treeCrop : TreeCrop.copy()) {
            saplings.add((Object)treeCrop.getSaplingItem());
        }
        for (Tree tree : Tree.copy()) {
            saplings.add((Object)tree.getSapling());
        }
    }

    protected void generateBarkLogs() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender burnableLog = this.tag(ItemTags.LOGS_THAT_BURN);
        for (Tree crop : Tree.copy()) {
            this.tag(crop.getLogItemTag()).add((Object)crop.getLog().asItem()).add((Object)crop.getStrippedLog().asItem()).add((Object)crop.getWood().asItem()).add((Object)crop.getStrippedWood().asItem());
            burnableLog.addTag(crop.getLogItemTag());
        }
    }

    protected void generateLeaves() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender leaves = this.tag(ItemTags.LEAVES);
        for (TreeCrop treeCrop : TreeCrop.copy()) {
            leaves.add((Object)treeCrop.getLeaves().asItem());
        }
        for (Tree tree : Tree.copy()) {
            leaves.add((Object)tree.getLeaves().asItem());
        }
    }

    protected void generateMisc() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender crops = this.tag(ItemTags.VILLAGER_PLANTABLE_SEEDS);
        for (Item seed : CroptopiaMod.seeds) {
            crops.add((Object)seed);
        }
        IntrinsicHolderTagsProvider.IntrinsicTagAppender fishes = this.tag(ItemTags.FISHES);
        fishes.add((Object)Content.ANCHOVY.asItem());
        fishes.add((Object)Content.CALAMARI.asItem());
        fishes.add((Object)Content.GLOWING_CALAMARI.asItem());
        fishes.add((Object)Content.CLAM.asItem());
        fishes.add((Object)Content.CRAB.asItem());
        fishes.add((Object)Content.OYSTER.asItem());
        fishes.add((Object)Content.ROE.asItem());
        fishes.add((Object)Content.SHRIMP.asItem());
        fishes.add((Object)Content.TUNA.asItem());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender foxFood = this.tag(ItemTags.FOX_FOOD);
        foxFood.add((Object)Content.BLACKBERRY.asItem());
        foxFood.add((Object)Content.BLUEBERRY.asItem());
        foxFood.add((Object)Content.CRANBERRY.asItem());
        foxFood.add((Object)Content.ELDERBERRY.asItem());
        foxFood.add((Object)Content.RASPBERRY.asItem());
        foxFood.add((Object)Content.STRAWBERRY.asItem());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender piglinFood = this.tag(ItemTags.PIGLIN_FOOD);
        piglinFood.add((Object)Content.HAM_SANDWICH);
        piglinFood.add((Object)Content.PEPPERONI);
        piglinFood.add((Object)Content.PORK_AND_BEANS);
        piglinFood.add((Object)Content.PORK_JERKY);
        piglinFood.add((Object)Content.RAW_BACON);
        piglinFood.add((Object)Content.COOKED_BACON.asItem());
    }
}

