/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime;

import einstein.usefulslime.init.ModArmorMaterials;
import einstein.usefulslime.init.ModBlocks;
import einstein.usefulslime.init.ModConfigs;
import einstein.usefulslime.init.ModItems;
import einstein.usefulslime.init.ModPackets;
import einstein.usefulslime.items.SlimeArmor;
import einstein.usefulslime.networking.serverbound.ServerBoundDamageSlimeBootsPacket;
import einstein.usefulslime.util.BounceHandler;
import einstein.usefulslime.util.LivingFallData;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsefulSlime {
    public static final String MOD_ID = "usefulslime";
    public static final String MOD_NAME = "Useful Slime";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Useful Slime");
    public static final ModConfigs CONFIGS = (ModConfigs)ConfigApiJava.registerAndLoadConfig(ModConfigs::new, (RegisterType)RegisterType.BOTH);

    public static void init() {
        ModArmorMaterials.init();
        ModBlocks.init();
        ModItems.init();
        ModPackets.init();
    }

    public static void onFall(LivingFallData data) {
        LivingEntity entity = data.getEntity();
        if (entity == null) {
            return;
        }
        ItemStack footStack = entity.getItemBySlot(EquipmentSlot.FEET);
        if (!(footStack.getItem() instanceof SlimeArmor)) {
            return;
        }
        float distance = data.getDistance();
        Level level = entity.level();
        if (!entity.isShiftKeyDown() && distance > 2.0f) {
            data.setDamageMultiplier(0.0f);
            entity.resetFallDistance();
            if (level.isClientSide) {
                double d = 0.9500000000000001;
                entity.setDeltaMovement(entity.getDeltaMovement().x, entity.getDeltaMovement().y * (double)-0.9f, entity.getDeltaMovement().z);
                entity.hasImpulse = true;
                entity.setOnGround(false);
                entity.setDeltaMovement(entity.getDeltaMovement().x / d, entity.getDeltaMovement().y, entity.getDeltaMovement().z / d);
                if (UsefulSlime.CONFIGS.bouncingDamagesSlimeBoots && ConfigApiJava.network().canSend(ServerBoundDamageSlimeBootsPacket.TYPE.id(), (Player)entity)) {
                    ConfigApiJava.network().send((CustomPacketPayload)new ServerBoundDamageSlimeBootsPacket(Math.round(distance / 10.0f)), (Player)entity);
                }
            } else {
                data.setCanceled(true);
            }
            entity.playSound(SoundEvents.SLIME_SQUISH);
            for (int i = 0; i < 8; ++i) {
                float random1 = entity.getRandom().nextFloat() * ((float)Math.PI * 2);
                float random2 = entity.getRandom().nextFloat() * 0.5f + 0.5f;
                float xOffset = Mth.sin((float)random1) * 0.5f * random2;
                float yOffset = Mth.cos((float)random1) * 0.5f * random2;
                level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, entity.getX() + (double)xOffset, entity.getY(), entity.getZ() + (double)yOffset, 0.0, 0.0, 0.0);
            }
            BounceHandler.addBounceHandler(entity, entity.getDeltaMovement().y);
        } else if (!level.isClientSide && entity.isShiftKeyDown()) {
            data.setDamageMultiplier(0.2f);
        }
        if (!UsefulSlime.CONFIGS.slimeBootSurfing && level.isClientSide && !entity.isShiftKeyDown() && (double)distance < 1.5) {
            BounceHandler.BOUNCING_ENTITIES.remove(entity);
        }
    }

    public static void onServerStopped(MinecraftServer server) {
        BounceHandler.BOUNCING_ENTITIES.clear();
    }

    public static void damageEquipment(LivingEntity entity, EquipmentSlot slot) {
        UsefulSlime.damageEquipment(entity, slot, 1);
    }

    public static void damageEquipment(LivingEntity entity, EquipmentSlot slot, int damage) {
        entity.getItemBySlot(slot).hurtAndBreak(damage, entity, slot);
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

