/*
 * Decompiled with CFR 0.152.
 */
package com.axedgaming.endersdelight.client.renderer;

import com.axedgaming.endersdelight.blocks.EndstoneStoveBlock;
import com.axedgaming.endersdelight.blocks.entity.EndstoneStoveBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.items.ItemStackHandler;

public class EndstoneStoveRenderer
implements BlockEntityRenderer<EndstoneStoveBlockEntity> {
    public EndstoneStoveRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EndstoneStoveBlockEntity stoveEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = ((Direction)stoveEntity.getBlockState().getValue((Property)EndstoneStoveBlock.FACING)).getOpposite();
        ItemStackHandler inventory = stoveEntity.getInventory();
        int posLong = (int)stoveEntity.getBlockPos().asLong();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stoveStack = inventory.getStackInSlot(i);
            if (stoveStack.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(0.5, 1.02, 0.5);
            float f = -direction.toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(f));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            Vec2 itemOffset = stoveEntity.getStoveItemOffset(i);
            poseStack.translate((double)itemOffset.x, (double)itemOffset.y, 0.0);
            poseStack.scale(0.375f, 0.375f, 0.375f);
            if (stoveEntity.getLevel() != null) {
                Minecraft.getInstance().getItemRenderer().renderStatic(stoveStack, ItemDisplayContext.FIXED, LevelRenderer.getLightColor((BlockAndTintGetter)stoveEntity.getLevel(), (BlockPos)stoveEntity.getBlockPos().above()), combinedOverlayIn, poseStack, buffer, stoveEntity.getLevel(), posLong + i);
            }
            poseStack.popPose();
        }
    }
}

