/*
 * Decompiled with CFR 0.152.
 */
package com.axedgaming.endersdelight.blocks.custom;

import com.axedgaming.endersdelight.blocks.custom.VoidpepperBushBE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class VoidpepperBush
extends Block {
    public static final BooleanProperty SPREADING = BooleanProperty.create((String)"spreading");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty PEPPER = BooleanProperty.create((String)"pepper");
    private static final int SPREAD_RADIUS = 7;

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.is(Blocks.END_STONE) || pState.getBlock() instanceof FarmBlock;
    }

    public VoidpepperBush(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SPREADING, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)PEPPER, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SPREADING, EAST, WEST, NORTH, SOUTH, UP, DOWN, PEPPER});
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!((Boolean)pState.getValue((Property)SPREADING)).booleanValue()) {
            return;
        }
        double chance = pRandom.nextDouble();
        if (chance < 0.6666666666666666) {
            this.spread(pLevel, pPos, pRandom);
        } else {
            pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)PEPPER, (Comparable)Boolean.valueOf(true))).setValue((Property)SPREADING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private void spread(ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos origin = pPos;
        for (int i = 0; i < 15; ++i) {
            BlockPos newPos = origin.offset(pRandom.nextInt(15) - 7, pRandom.nextInt(15) - 7, pRandom.nextInt(15) - 7);
            if (newPos.distManhattan((Vec3i)origin) > 7 || !pLevel.getBlockState(newPos.below()).is(Blocks.END_STONE) && !pLevel.getBlockState(newPos.north()).is(Blocks.END_STONE) && !pLevel.getBlockState(newPos.south()).is(Blocks.END_STONE) && !pLevel.getBlockState(newPos.west()).is(Blocks.END_STONE) && !pLevel.getBlockState(newPos.east()).is(Blocks.END_STONE) && !pLevel.getBlockState(newPos.above()).is(Blocks.END_STONE) || !pLevel.isEmptyBlock(newPos)) continue;
            BlockState newState = this.setBlockStateDirections((Level)pLevel, newPos);
            pLevel.setBlock(newPos, newState, 2);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, newPos, GameEvent.Context.of((BlockState)newState));
            break;
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new VoidpepperBushBE(pPos, pState, pPos);
    }

    private BlockState setBlockStateDirections(Level level, BlockPos pPos) {
        BlockState newState = this.defaultBlockState();
        newState = (BlockState)newState.setValue((Property)DOWN, (Comparable)Boolean.valueOf(level.getBlockState(pPos.below()).is(Blocks.END_STONE)));
        newState = (BlockState)newState.setValue((Property)UP, (Comparable)Boolean.valueOf(level.getBlockState(pPos.above()).is(Blocks.END_STONE)));
        newState = (BlockState)newState.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(level.getBlockState(pPos.north()).is(Blocks.END_STONE)));
        newState = (BlockState)newState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(level.getBlockState(pPos.south()).is(Blocks.END_STONE)));
        newState = (BlockState)newState.setValue((Property)EAST, (Comparable)Boolean.valueOf(level.getBlockState(pPos.west()).is(Blocks.END_STONE)));
        newState = (BlockState)newState.setValue((Property)WEST, (Comparable)Boolean.valueOf(level.getBlockState(pPos.east()).is(Blocks.END_STONE)));
        return newState;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState newState = this.setBlockStateDirections(level, pos);
        level.setBlock(pos, newState, 2);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.setBlockStateDirections(context.getLevel(), context.getClickedPos());
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        BlockState belowBlockState = pLevel.getBlockState(blockpos);
        TriState soilDecision = belowBlockState.canSustainPlant((BlockGetter)pLevel, blockpos, Direction.UP, pState);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return this.mayPlaceOn(belowBlockState, (BlockGetter)pLevel, blockpos);
    }

    protected BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0));
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0));
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0));
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        }
        if (shape.isEmpty()) {
            shape = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        }
        return shape;
    }
}

