/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.core.SoundPlayback;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.item.FakeItemUseContext;
import net.silentchaos512.lib.util.NameUtils;

public class BlockPlacerTraitEffect
extends TraitEffect {
    public static final MapCodec<BlockPlacerTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("block").forGetter(e -> e.blockState), (App)Codec.INT.fieldOf("damage_on_use").forGetter(e -> e.damageOnUse), (App)Codec.INT.fieldOf("cooldown").forGetter(e -> e.cooldown), (App)SoundPlayback.CODEC.optionalFieldOf("sound", null).forGetter(e -> e.sound)).apply((Applicative)instance, BlockPlacerTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockPlacerTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), e -> e.blockState.getBlock(), (StreamCodec)ByteBufCodecs.VAR_INT, e -> e.damageOnUse, (StreamCodec)ByteBufCodecs.VAR_INT, e -> e.cooldown, SoundPlayback.STREAM_CODEC, e -> e.sound, (block, damageOnUse, cooldown, sound) -> new BlockPlacerTraitEffect(block.defaultBlockState(), (int)damageOnUse, (int)cooldown, (SoundPlayback)sound));
    private final BlockState blockState;
    private final int damageOnUse;
    private final int cooldown;
    @Nullable
    private final SoundPlayback sound;

    public BlockPlacerTraitEffect(BlockState blockState, int damageOnUse, int cooldown, @Nullable SoundPlayback sound) {
        this.blockState = blockState;
        this.damageOnUse = damageOnUse;
        this.cooldown = cooldown;
        this.sound = sound;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.BLOCK_PLACER.get();
    }

    @Override
    public InteractionResult onItemUse(UseOnContext context, int traitLevel) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!(world.isClientSide || this.damageOnUse >= 1 && stack.getDamageValue() >= stack.getMaxDamage() - this.damageOnUse - 1)) {
            ItemStack fakeBlockStack = new ItemStack((ItemLike)this.blockState.getBlock());
            InteractionResult result = fakeBlockStack.useOn((UseOnContext)new FakeItemUseContext(context, fakeBlockStack));
            if (result.consumesAction()) {
                if (this.damageOnUse > 0 && context.getPlayer() != null) {
                    GearHelper.attemptDamage(stack, this.damageOnUse, (LivingEntity)context.getPlayer(), context.getHand());
                }
                if (this.sound != null) {
                    this.sound.playAt(world, pos, SoundSource.BLOCKS);
                }
                if (this.cooldown > 0 && context.getPlayer() != null) {
                    context.getPlayer().getCooldowns().addCooldown(stack.getItem(), this.cooldown);
                }
            }
            return result;
        }
        for (int i = 0; i < 5; ++i) {
            PhantomLight.spawnParticle((LevelAccessor)world, pos.relative(context.getClickedFace()), SilentGear.RANDOM_SOURCE);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("  - Places: " + String.valueOf(NameUtils.fromBlock((BlockState)this.blockState)));
        ret.add("  - Durability Cost: " + this.damageOnUse);
        if (this.cooldown > 0) {
            ret.add("  - Cooldown: " + this.cooldown);
        }
        return ret;
    }
}

