/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.util.ModelPropertiesHelper;
import net.silentchaos512.gear.item.gear.GearCrossbowItem;
import net.silentchaos512.lib.client.gui.DebugRenderOverlay;

public class DebugOverlay
extends DebugRenderOverlay {
    private static final int SPLIT_WIDTH = 160;
    private static final float TEXT_SCALE = 0.7f;

    @Nonnull
    public List<String> getDebugText() {
        EntityHitResult ert;
        Entity entity;
        ArrayList<String> list = new ArrayList<String>();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return list;
        }
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            return list;
        }
        Item item = heldItem.getItem();
        if (item instanceof GearCrossbowItem) {
            float pull = ModelPropertiesHelper.getValue(heldItem, ResourceLocation.withDefaultNamespace((String)"pull"), mc.level, (LivingEntity)player);
            float pulling = ModelPropertiesHelper.getValue(heldItem, ResourceLocation.withDefaultNamespace((String)"pulling"), mc.level, (LivingEntity)player);
            float charged = ModelPropertiesHelper.getValue(heldItem, ResourceLocation.withDefaultNamespace((String)"charged"), mc.level, (LivingEntity)player);
            float firework = ModelPropertiesHelper.getValue(heldItem, ResourceLocation.withDefaultNamespace((String)"firework"), mc.level, (LivingEntity)player);
            list.add(String.format("pull=%.1f", Float.valueOf(pull)));
            list.add(String.format("pulling=%.1f", Float.valueOf(pulling)));
            list.add(String.format("charged=%.1f", Float.valueOf(charged)));
            list.add(String.format("firework=%.1f", Float.valueOf(firework)));
            list.add(String.format("chargeTime=%d", GearCrossbowItem.getChargeTime(heldItem)));
            return list;
        }
        HitResult rt = mc.hitResult;
        if (rt != null && rt.getType() == HitResult.Type.BLOCK) {
            BlockHitResult brt = (BlockHitResult)rt;
            Entity renderViewEntity = mc.getCameraEntity();
            if (renderViewEntity != null) {
                BlockPos pos = brt.getBlockPos();
                BlockState blockState = renderViewEntity.level().getBlockState(pos);
            }
        } else if (rt != null && rt.getType() == HitResult.Type.ENTITY && (entity = (ert = (EntityHitResult)rt).getEntity()) instanceof LivingEntity) {
            list.add(String.format("%s", entity.getScoreboardName()));
            list.add(String.format("health = %.3f", Float.valueOf(((LivingEntity)entity).getHealth())));
        }
        return list;
    }

    public float getTextScale() {
        return 0.7f;
    }

    public int getSplitWidth() {
        return 160;
    }

    public boolean isHidden() {
        return !SilentGear.isDevBuild();
    }
}

