/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import java.util.List;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.config.ToolsConfigTranslations;
import mekanism.tools.common.material.IPaxelMaterial;
import mekanism.tools.common.material.VanillaPaxelMaterial;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.Tool;
import net.neoforged.neoforge.common.ModConfigSpec;

@NothingNullByDefault
public class VanillaPaxelMaterialCreator
implements IPaxelMaterial {
    private final VanillaPaxelMaterial fallback;
    private final CachedFloatValue paxelDamage;
    private final CachedFloatValue paxelAtkSpeed;
    private final CachedFloatValue paxelEfficiency;
    private final CachedIntValue paxelEnchantability;
    private final CachedIntValue paxelDurability;

    public VanillaPaxelMaterialCreator(IMekanismConfig config, ModConfigSpec.Builder builder, VanillaPaxelMaterial materialDefaults) {
        this.fallback = materialDefaults;
        String toolKey = this.getRegistryPrefix();
        ToolsConfigTranslations.VanillaPaxelMaterialTranslations translations = ToolsConfigTranslations.VanillaPaxelMaterialTranslations.create(toolKey);
        translations.topLevel().applyToBuilder(builder).push(toolKey);
        this.paxelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.damage().applyToBuilder(builder).gameRestart().define(toolKey + "PaxelDamage", this.validateDefaultModifier(materialDefaults.getPaxelDamage()), this::validateDamageModifier));
        this.paxelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.attackSpeed().applyToBuilder(builder).gameRestart().define(toolKey + "PaxelAtkSpeed", (Object)materialDefaults.getPaxelAtkSpeed()));
        this.paxelEfficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.efficiency().applyToBuilder(builder).gameRestart().define(toolKey + "PaxelEfficiency", (Object)materialDefaults.getPaxelEfficiency()));
        this.paxelEnchantability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.enchantability().applyToBuilder(builder).gameRestart().defineInRange(toolKey + "PaxelEnchantability", materialDefaults.getPaxelEnchantability(), 0, Integer.MAX_VALUE));
        this.paxelDurability = CachedIntValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.durability().applyToBuilder(builder).gameRestart().defineInRange(toolKey + "PaxelDurability", materialDefaults.getPaxelDurability(), 1, Integer.MAX_VALUE));
        builder.pop();
    }

    private boolean validateDamageModifier(Object value) {
        if (value instanceof Double) {
            double val = (Double)value;
            float actualValue = val > 3.4028234663852886E38 ? Float.MAX_VALUE : (val < -3.4028234663852886E38 ? -3.4028235E38f : (float)val);
            float baseDamage = this.getVanillaTier().getAttackDamageBonus();
            return actualValue >= -baseDamage && actualValue <= Float.MAX_VALUE - baseDamage;
        }
        return false;
    }

    private Supplier<Double> validateDefaultModifier(double defaultModifier) {
        return () -> {
            if (this.validateDamageModifier(defaultModifier)) {
                return defaultModifier;
            }
            return -this.getVanillaTier().getAttackDamageBonus();
        };
    }

    public Tiers getVanillaTier() {
        return this.fallback.getVanillaTier();
    }

    public String getRegistryPrefix() {
        return this.fallback.getRegistryPrefix();
    }

    @Override
    public int getPaxelDurability() {
        return this.paxelDurability.getOrDefault();
    }

    @Override
    public float getPaxelEfficiency() {
        return this.paxelEfficiency.get();
    }

    @Override
    public float getPaxelDamage() {
        return this.paxelDamage.getOrDefault();
    }

    @Override
    public float getPaxelAtkSpeed() {
        return this.paxelAtkSpeed.getOrDefault();
    }

    @Override
    public int getPaxelEnchantability() {
        return this.paxelEnchantability.get();
    }

    public Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.deniesDrops((TagKey)this.getVanillaTier().getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops(ToolsTags.Blocks.MINEABLE_WITH_PAXEL, (float)this.getPaxelEfficiency())), 1.0f, 1);
    }
}

