/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import info.u_team.u_team_core.util.FontUtil;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class WidgetUtil {
    private static final String ELLIPSIS = "...";

    public static <T extends AbstractWidget & BackgroundColorProvider> void renderWidget(T widget, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableDepthTest();
        ((WidgetRenderable)widget).renderWidgetTexture(guiGraphics, mouseX, mouseY, partialTick);
        ((PerspectiveRenderable)widget).renderBehind(guiGraphics, mouseX, mouseY, partialTick);
        ((PerspectiveRenderable)widget).renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        if (widget instanceof TooltipRenderable) {
            TooltipRenderable tooltipRenderable = (TooltipRenderable)widget;
            WidgetUtil.renderCustomTooltipForWidget(tooltipRenderable, guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public static <T extends AbstractWidget> void renderButtonLikeTexture(T widget, TextureProvider textureProvider, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.setShaderColor(WidgetUtil.respectWidgetAlpha(widget, ((BackgroundColorProvider)widget).getCurrentBackgroundColor(guiGraphics, mouseY, mouseY, partialTick)));
        guiGraphics.blitSprite(textureProvider.getTexture(), widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
        RenderUtil.resetShaderColor();
    }

    public static <T extends AbstractWidget> void renderText(T widget, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scale;
        Font font = ((TextSettingsProvider)widget).getCurrentTextFont();
        TextSettingsProvider.TextRenderType renderType = ((TextSettingsProvider)widget).getCurrentTextRenderType();
        Component message = ((TextProvider)widget).getCurrentText();
        RGBA color = WidgetUtil.respectWidgetAlpha(widget, ((TextSettingsProvider)widget).getCurrentTextColor(guiGraphics, mouseX, mouseY, partialTick));
        if (widget instanceof ScaleProvider) {
            ScaleProvider scaleProvider = (ScaleProvider)widget;
            scale = scaleProvider.getCurrentScale(guiGraphics, mouseY, mouseY, partialTick);
        } else {
            scale = 1.0f;
        }
        if (message == CommonComponents.EMPTY) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.scale(scale, scale, 0.0f);
        if (renderType == TextSettingsProvider.TextRenderType.ELLIPSIS) {
            WidgetUtil.renderTextWithCutoff(widget, font, message, color, scale, guiGraphics, mouseX, mouseY, partialTick);
        } else if (renderType == TextSettingsProvider.TextRenderType.SCROLLING) {
            WidgetUtil.renderTextWithScrolling(widget, font, message, color, scale, guiGraphics, mouseX, mouseY, partialTick);
        }
        poseStack.popPose();
    }

    private static void renderTextWithScrolling(AbstractWidget widget, Font font, Component message, RGBA color, float scale, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float positionFactor = 1.0f / scale;
        int maxWidth = widget.getWidth() - 6;
        int messageWidth = Mth.ceil((float)(scale * (float)font.width((FormattedText)message)));
        float yStart = (float)(widget.getY() + Mth.ceil((float)((float)widget.getHeight() - 9.0f * scale)) / 2 + 1) * positionFactor;
        if (messageWidth > maxWidth) {
            int difference = messageWidth - maxWidth;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)difference * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)difference);
            float xStart = (float)(widget.getX() + 3 - (int)d3) * positionFactor;
            guiGraphics.enableScissor(widget.getX() + 3, widget.getY(), widget.getX() + widget.getWidth() - 3, widget.getY() + widget.getHeight());
            FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
            guiGraphics.disableScissor();
        } else {
            float xStart = (float)(widget.getX() + widget.getWidth() / 2 - messageWidth / 2) * positionFactor;
            FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
        }
    }

    private static void renderTextWithCutoff(AbstractWidget widget, Font font, Component message, RGBA color, float scale, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float positionFactor = 1.0f / scale;
        int maxWidth = widget.getWidth() - 6;
        int messageWidth = Mth.ceil((float)(scale * (float)font.width((FormattedText)message)));
        int ellipsisWidth = Mth.ceil((float)(scale * (float)font.width(ELLIPSIS)));
        if (messageWidth > maxWidth && messageWidth > ellipsisWidth) {
            message = Component.literal((String)(font.substrByWidth((FormattedText)message, Mth.floor((float)((float)maxWidth * positionFactor)) - ellipsisWidth).getString() + ELLIPSIS));
            messageWidth = maxWidth;
        }
        float xStart = (float)(widget.getX() + widget.getWidth() / 2 - messageWidth / 2) * positionFactor;
        float yStart = (float)(widget.getY() + Mth.ceil((float)((float)widget.getHeight() - 9.0f * scale)) / 2 + 1) * positionFactor;
        FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
    }

    public static RGBA respectWidgetAlpha(AbstractWidget widget, RGBA color) {
        return color.setAlphaComponent(color.getAlphaComponent() * Mth.clamp((float)widget.alpha, (float)0.0f, (float)1.0f));
    }

    public static void renderCustomTooltipForWidget(TooltipRenderable renderable, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        renderable.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
        poseStack.popPose();
    }
}

