/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.logging.LogUtils;
import info.u_team.u_team_core.util.CastUtil;
import java.lang.reflect.Field;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.slf4j.Logger;

public class ReflectionUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Field findField(Class<?> clazz, String field) {
        return ObfuscationReflectionHelper.findField(clazz, (String)field);
    }

    public static <I, V> void setValue(Field field, I instance, V value) {
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            AccessFieldException exception = new AccessFieldException("", ex);
            LOGGER.error("Unable to set any field {} on type {}", new Object[]{field.getName(), field.getDeclaringClass(), exception});
            throw exception;
        }
    }

    public static <I, V> V getValue(Field field, I instance) {
        try {
            return (V)CastUtil.uncheckedCast(field.get(instance));
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException ex) {
            AccessFieldException exception = new AccessFieldException("", ex);
            LOGGER.error("Unable to access field {} on type {}", new Object[]{field.getName(), field.getDeclaringClass(), exception});
            throw exception;
        }
    }

    public static <O, N> void copyValue(Field field, O oldInstance, N newInstance) {
        ReflectionUtil.setValue(field, newInstance, ReflectionUtil.getValue(field, oldInstance));
    }

    private static class AccessFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AccessFieldException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

