/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.OpenMenuScreenMessage;
import info.u_team.u_team_core.util.ByteBufUtil;
import info.u_team.u_team_core.util.ServiceUtil;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MenuUtil {
    public static OptionalInt openMenu(ServerPlayer player, MenuProvider menuProvider, Consumer<FriendlyByteBuf> data, boolean sendClosePacket) {
        if (player.containerMenu != player.inventoryMenu) {
            if (sendClosePacket) {
                player.closeContainer();
            } else {
                player.doCloseContainer();
            }
        }
        player.nextContainerCounter();
        AbstractContainerMenu menu = menuProvider.createMenu(player.containerCounter, player.getInventory(), (Player)player);
        if (menu == null) {
            if (player.isSpectator()) {
                player.displayClientMessage((Component)Component.translatable((String)"container.spectatorCantOpen").withStyle(ChatFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        byte[] extraData = ByteBufUtil.writeCustomDataToByteArray(data);
        UCoreNetwork.OPEN_MENU_SCREEN_MESSAGE.sendToPlayer(player, new OpenMenuScreenMessage(menu.containerId, menu.getType(), menuProvider.getDisplayName(), extraData));
        player.initMenu(menu);
        player.containerMenu = menu;
        Extension.INSTANCES.forEach(extension -> extension.menuOpened(player, menu));
        return OptionalInt.of(player.containerCounter);
    }

    public static interface Extension {
        public static final List<Extension> INSTANCES = ServiceUtil.loadAll(Extension.class);

        public void menuOpened(ServerPlayer var1, AbstractContainerMenu var2);
    }
}

