/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.item.tier;

import com.google.common.base.Suppliers;
import info.u_team.u_team_core.api.item.ExtendedTier;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class UExtendedTier
implements ExtendedTier {
    private final Map<ExtendedTier.Tools, Float> attackDamage = new EnumMap<ExtendedTier.Tools, Float>(ExtendedTier.Tools.class);
    private final Map<ExtendedTier.Tools, Float> attackSpeed;
    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float attackDamageBonus;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    public UExtendedTier(Map<ExtendedTier.Tools, Float> attackDamage, Map<ExtendedTier.Tools, Float> attackSpeed, TagKey<Block> incorrectBlocksForDrops, int uses, float speed, float attackDamageBonus, int enchantmentValue, Supplier<Ingredient> repairIngredient) {
        this.attackDamage.putAll(attackDamage);
        this.attackSpeed = new EnumMap<ExtendedTier.Tools, Float>(ExtendedTier.Tools.class);
        this.attackSpeed.putAll(attackSpeed);
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.uses = uses;
        this.speed = speed;
        this.attackDamageBonus = attackDamageBonus;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.attackDamageBonus;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    @Override
    public float getAttackDamage(ExtendedTier.Tools tools) {
        return this.attackDamage.getOrDefault((Object)tools, Float.valueOf(-1000.0f)).floatValue();
    }

    @Override
    public float getAttackSpeed(ExtendedTier.Tools tools) {
        return this.attackSpeed.getOrDefault((Object)tools, Float.valueOf(-1000.0f)).floatValue();
    }
}

