/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.menu.UContainerMenu;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record DataHolderMenuMessage(int containerId, int index, byte[] dataHolderBuffer) {
    public static final StreamCodec<RegistryFriendlyByteBuf, DataHolderMenuMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, DataHolderMenuMessage::containerId, (StreamCodec)ByteBufCodecs.VAR_INT, DataHolderMenuMessage::index, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, DataHolderMenuMessage::dataHolderBuffer, DataHolderMenuMessage::new);

    public static void handle(DataHolderMenuMessage message, NetworkContext context) {
        context.executeOnMainThread(() -> {
            Player player = context.getPlayer();
            if (player != null) {
                DataHolderMenuMessage.updateDataHolder(player.containerMenu, context.getEnvironment(), message);
            }
        });
    }

    private static void updateDataHolder(AbstractContainerMenu menuToTest, NetworkEnvironment environment, DataHolderMenuMessage message) {
        DataHolderMenuMessage.testContainerMenu(menuToTest, message.containerId).ifPresent(menu -> {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message.dataHolderBuffer));
            try {
                menu.setDataHolder(environment, message.index, buffer);
            }
            finally {
                buffer.release();
            }
        });
    }

    private static Optional<UContainerMenu> testContainerMenu(AbstractContainerMenu menu, int containerId) {
        if (menu instanceof UContainerMenu) {
            UContainerMenu uContainer = (UContainerMenu)menu;
            if (menu.containerId == containerId) {
                return Optional.of(uContainer);
            }
        }
        return Optional.empty();
    }
}

